% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dorfman.Functions.R
\name{thresh.val.dorf}
\alias{thresh.val.dorf}
\title{Find the optimal threshold value for Thresholded Optimal 
Dorfman testing}
\usage{
thresh.val.dorf(p, psz, se = 1, sp = 1)
}
\arguments{
\item{p}{a vector of each individual's probability of infection.}

\item{psz}{the initial pool size.}

\item{se}{the sensitivity of the diagnostic test.}

\item{sp}{the specificity of the diagnostic test.}
}
\value{
The optimal threshold value for TOD testing.
}
\description{
Find the optimal threshold value for Thresholded Optimal
Dorfman (TOD) testing.
}
\details{
This function finds the optimal threshold value for TOD 
testing for situations where the threshold value is not specified. 
See McMahan et al. (2012) for additional details on the implementation 
of TOD testing.
}
\examples{
# This example takes approximately 4 seconds to run. 
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
\dontrun{
set.seed(3154)
p.vec <- p.vec.func(p=0.10, alpha=0.5, grp.sz=1000)
thresh.val.dorf(p=p.vec, psz=10, se=0.95, sp=0.95)}

# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
p.vec <- p.vec.func(p=0.15, alpha=2, grp.sz=100)
thresh.val.dorf(p=p.vec, psz=10, se=0.95, sp=0.95)
}
\references{
\insertRef{McMahan2012a}{binGroup}
}
\seealso{
\url{http://chrisbilder.com/grouptesting}

Other Informative Dorfman functions: \code{\link{accuracy.dorf}},
  \code{\link{characteristics.pool}},
  \code{\link{inf.dorf.measures}},
  \code{\link{opt.info.dorf}}, \code{\link{opt.pool.size}},
  \code{\link{pool.specific.dorf}}
}
\author{
This function was originally written by Christopher S. 
McMahan for McMahan et al. (2012). The function was obtained 
from \url{http://chrisbilder.com/grouptesting}.
}
