% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_callbacks.R
\name{bb_callbacks}
\alias{bb_callbacks}
\title{Callbacks for billboard charts}
\usage{
bb_callbacks(
  bb,
  onafterinit = NULL,
  onbeforeinit = NULL,
  oninit = NULL,
  onout = NULL,
  onover = NULL,
  onrendered = NULL,
  onresize = NULL,
  onresized = NULL
)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{onafterinit}{Set a callback to execute after the chart is initialized.}

\item{onbeforeinit}{Set a callback to execute before the chart is initialized.}

\item{oninit}{Set a callback to execute when the chart is initialized.}

\item{onout}{Set a callback to execute when mouse/touch leaves the chart.}

\item{onover}{Set a callback to execute when mouse/touch enters the chart.}

\item{onrendered}{Set a callback which is executed when the chart is rendered.
Basically, this callback will be called in each time when the chart is redrawed.}

\item{onresize}{Set a callback to execute when user resizes the screen.}

\item{onresized}{Set a callback to execute when screen resize finished.}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Callbacks for billboard charts
}
\note{
Set JavaScript callbacks for various billboard events.
 See the \href{https://naver.github.io/billboard.js/release/latest/doc/Options.html}{billboard options} 
 reference for additional details on the signature of each callback.
}
