% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bikm1_LBM_Poisson_functions.R
\name{CARI}
\alias{CARI}
\title{CARI function for agreement between coclustering partitions}
\usage{
CARI(v,w,vprime,wprime)
}
\arguments{
\item{v}{numeric vector  specifying the class of  rows.}

\item{w}{numeric vector specifying the class of columns.}

\item{vprime}{numeric vector  specifying another partitions of rows.}

\item{wprime}{numeric vector specifying another partition of columns.}
}
\value{
a list including the arguments:

\code{cari}: value of the index.

\code{nvw}: contingency table which the index is based on.
}
\description{
Produce a measure of agreement between two pairs of partitions for coclustering. A value of 1 means a perfect match.
}
\examples{
\donttest{require(bikm1)
J=200
K=120
h=3
l=2
theta=list()
theta$rho_h=1/h *matrix(1,h,1)
theta$tau_l=1/l *matrix(1,l,1)
theta$gamma_hl=matrix(c(1, 6,4, 1, 7, 1),ncol=2)
data=PoissonBlocRnd(J,K,theta)
res=BIKM1_LBM_Poisson(data$x,4,4,4,init_choice='smallVBayes')
me=CARI(res@model_max$v,res@model_max$w, data$xrow,data$xcol)
me$cari
me$nvw}
}
\references{
Robert and Vasseur. Comparing high dimensional partitions with the Coclustering Adjusted Rand Index, Preprint (2017).
}
