% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier-tukey.R
\name{tukey_mc_up}
\alias{tukey_mc_up}
\title{Outlier detection threshold (upper)}
\usage{
tukey_mc_up(x, coef = NULL, alpha = 0.05, a = -4, b = 3)
}
\arguments{
\item{x}{Numeric vector. Should be somewhat normally distributed.}

\item{coef}{number determining how far 'whiskers' extend out from the box.
If \code{NULL} (default), this is computed to get an type-I error of \code{alpha},
after adjusting for multiple testing. A standard value to use is \code{1.5}.}

\item{alpha}{See \code{coef}. Default is \code{0.05}.}

\item{a}{scaling factors multiplied by the medcouple
    \code{\link[robustbase]{mc}()} to determine outlyer boundaries; see the references.}

\item{b}{scaling factors multiplied by the medcouple
    \code{\link[robustbase]{mc}()} to determine outlyer boundaries; see the references.}
}
\description{
Outlier detection threshold (upper) based on Tukey's rule, corrected for
skewness using the 'medcouple', and possibly corrected for multiple testing.
}
\examples{
hist(x <- c(rnorm(3, m = 6), rnorm(1e4, m = 0)))
(q <- tukey_mc_up(x))
abline(v = q, col = "red")
which(x > q)
}
\references{
%% Hubert, M. and Vandervieren, E. (2006)
%% \emph{An Adjusted Boxplot for Skewed Distributions},
%% Technical Report TR-06-11, KU Leuven, Section of Statistics, Leuven.
%% \url{http://wis.kuleuven.be/stat/robust/Papers/TR0611.pdf}

  Hubert, M. and Vandervieren, E. (2008).
  An adjusted boxplot for skewed distributions,
  \emph{Computational Statistics and Data Analysis} \bold{52}, 5186--5201.
}
\seealso{
\code{\link[robustbase:adjbox]{robustbase::adjbox()}}
}
