% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hvar.R
\name{sparseVAR}
\alias{sparseVAR}
\title{Sparse Estimation of the Vector AutoRegressive (VAR) Model}
\usage{
sparseVAR(Y, p = NULL, VARpen = "HLag", VARlseq = NULL, VARgran = NULL,
  VARalpha = 0, cvcut = 0.9, h = 1, eps = 0.001)
}
\arguments{
\item{Y}{A \eqn{T} by \eqn{k} matrix of time series. If k=1, a univariate autoregressive model is estimated.}

\item{p}{User-specified maximum autoregressive lag order of the VAR. Typical usage is to have the program compute its own maximum lag order based on the time series length.}

\item{VARpen}{"HLag" (hierarchical sparse penalty) or "L1" (standard lasso penalty) penalization.}

\item{VARlseq}{User-specified grid of values for regularization parameter corresponding to sparse penalty. Typical usage is to have the program compute
its own grid. Supplying a grid of values overrides this. WARNING: use with care.}

\item{VARgran}{User-specified vector of granularity specifications for the penalty parameter grid:  First element specifies
how deep the grid should be constructed. Second element specifies how many values the grid should contain.}

\item{VARalpha}{a small positive regularization parameter value corresponding to squared Frobenius penalty. The default is zero.}

\item{cvcut}{Proportion of observations used for model estimation in the time series cross-validation procedure. The remainder is used for forecast evaluation.}

\item{h}{Desired forecast horizon in time-series cross-validation procedure.}

\item{eps}{a small positive numeric value giving the tolerance for convergence in the proximal gradient algorithm.}
}
\value{
A list with the following components
\item{Y}{\eqn{T} by \eqn{k} matrix of time series.}
\item{k}{Number of time series.}
\item{p}{Maximum autoregressive lag order of the VAR.}
\item{Phihat}{Matrix of estimated autoregressive coefficients of the VAR.}
\item{phi0hat}{vector of VAR intercepts.}
}
\description{
Sparse Estimation of the Vector AutoRegressive (VAR) Model
}
\examples{
data(Y)
VARfit <- sparseVAR(Y) # sparse VAR
y <- matrix(Y[,1], ncol=1)
ARfit <- sparseVAR(y) # sparse AR
}
\references{
Nicholson William B., Bien Jacob and Matteson David S. (2017), "High Dimensional Forecasting via Interpretable Vector Autoregression"
arXiv preprint <arXiv:1412.5250v2>.
}
\seealso{
\link{lagmatrix} and \link{directforecast}
}
