% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{big_read}
\alias{big_read}
\title{Read a file}
\usage{
big_read(file, file.nheader = 0, file.nline = NULL, info.nelem = 0,
  split = " ", read.what = double(), read.transfo = identity,
  BM.type = typeof(read.what), transpose = FALSE, ...)
}
\arguments{
\item{file}{The path to the file to be read.}

\item{file.nheader}{Number of lines to read at the beginning of the file,
as a separate header information. Default is \code{0}. Each line is read as one
string. You may need to postprocess it with \link{strsplit}. See examples.}

\item{file.nline}{Number of total lines of the file. Default is \code{NULL} and a
function computes it. This function doesn't work for compressed files so that
you will have to explicitly specify the number of lines of the file.}

\item{info.nelem}{Number of elements of extra information to read at the
beginning of each line. Default is \code{0}.}

\item{split}{The separator used in the file. Default is a space.}

\item{read.what}{What type of elements to scan? Default is \code{double()}.
You can also use \code{character()} or \code{integer()}.}

\item{read.transfo}{Function that transforms each line you read.}

\item{BM.type}{Type of the resulting Filebacked Big Matrix. Default uses the
type of \code{read.what}. This can be useful if you have only small integers or
that the \code{read.transfo} function transforms the type of what is read.}

\item{transpose}{Should the resulting Filebacked Big Matrix be transposed?
Default is \code{FALSE}.}

\item{...}{Arguments passed on to \code{FBM}
\describe{
  \item{backingfile}{Path to the file storing the Big Matrix on disk.
An extension ".bk" will be automatically added. Default stores in the
temporary directory.}
  \item{create_bk}{Create a backingfile (the default) or use an existing one
(which should be named by the \code{backingfile} parameter and have an
extension ".bk"). For example, this could be used to convert a filebacked
\code{big.matrix} from package \strong{bigmemory} to a \link[=FBM-class]{FBM}.}
  \item{save}{Whether to save the result object in an ".rds" file alongside
the backingfile. Default is \code{FALSE}.}
}}
}
\value{
A Filebacked Big Matrix with two attributes \code{header} and \code{info}.
}
\description{
Read a file as a Filebacked Big Matrix.
For a mini-tutorial, please see \href{https://goo.gl/91oNxU}{this vignette}.
}
