% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr.r
\name{src_bigquery}
\alias{src_bigquery}
\title{A bigquery data source.}
\usage{
src_bigquery(project, dataset, billing = project, max_pages = 10)
}
\arguments{
\item{project}{project id or name}

\item{dataset}{dataset name}

\item{billing}{billing project, if different to \code{project}}

\item{max_pages}{(IGNORED) max pages returned by a query}
}
\description{
Use \code{src_bigquery} to connect to an existing bigquery dataset,
and \code{tbl} to connect to tables within that database.
}
\examples{
\dontrun{
library(dplyr)

# To run this example, replace billing with the id of one of your projects
# set up for billing
con <- DBI::dbConnect(dbi_driver(),
  project = "publicdata",
  dataset = "samples",
  billing = "887175176791"
)

DBI::dbListTables(con)
DBI::dbGetQuery(con, "SELECT * FROM gsod LIMIT 5")

# You can also use the dplyr interface
shakespeare <- con \%>\% tbl("shakespeare")
shakespeare
shakespeare \%>\%
  group_by(word) \%>\%
  summarise(n = sum(word_count)) \%>\%
  arrange(desc(n))
}
}
