% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bigpca.R
\name{prv.big.matrix}
\alias{prv.big.matrix}
\title{Tidier display function for big matrix objects}
\usage{
prv.big.matrix(bigMat, dir = "", rows = 3, cols = 2, name = NULL,
  dat = TRUE, descr = NULL, bck = NULL, mem = FALSE, rcap = "",
  ccap = "", ...)
}
\arguments{
\item{bigMat}{the description file, big.matrix object, or big.matrix.descriptor object,
anything that can be read by get.big.matrix()}

\item{dir}{the directory containing the big.matrix backing/description files}

\item{rows}{integer, number of rows to display}

\item{cols}{integer, number of columns to display}

\item{name}{logical, whether to print a name for the matrix}

\item{dat}{logical, whether to print any of the matrix contents (overrides row/col)}

\item{descr}{character, optional name of the description file, which if not null will be displayed}

\item{bck}{character, optional name of the backing file, which if not null will be displayed}

\item{mem}{logical, whether to display the amount of memory used by the object}

\item{rcap}{character, caption to display for the rows}

\item{ccap}{character, caption to display for the columns}

\item{...}{additional arguments to prv.large (from NCmisc) which displays the end result}
}
\value{
Prints to console a compact representation of the bigMat matrix,
 with the first few rows and columns, and the last row and column. Note that sometimes
 the initial printing of a big.matrix can take a little while. But subsequently the printout
 should be almost instantaneous.
}
\description{
This function prints the first and last columns and rows of a big matrix, and
a few more than this if desired. Allows previewing of a big.matrix without
overloading the console.
}
\examples{
bM <- filebacked.big.matrix(20, 50,
       dimnames = list(paste("r",1:20,sep=""), paste("c",1:50,sep="")),
       backingfile = "test.bck",  backingpath = getwd(), descriptorfile = "test.dsc")
bM[1:20,] <- replicate(50,rnorm(20))
prv.big.matrix(bM)
prv.big.matrix(bM,rows=10,cols=4)
unlink(c("test.dsc","test.bck"))  # clean up files
}
\seealso{
\code{\link{get.big.matrix}}
}

