% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{split_costs}
\alias{split_costs}
\title{Split costs in blocks}
\usage{
split_costs(costs, nb_split)
}
\arguments{
\item{costs}{Vector of costs (e.g. proportional to computation time).}

\item{nb_split}{Number of blocks.}
}
\value{
A matrix with 4 columns \code{lower}, \code{upper}, \code{size} and \code{cost}.
}
\description{
Split costs in consecutive blocks using a greedy algorithm that tries to
find blocks of even total cost.
}
\examples{
split_costs(costs = 150:1, nb_split = 3)
split_costs(costs = rep(1, 151), nb_split = 3)
split_costs(costs = 150:1, nb_split = 30)

}
