% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary_layer_conductance.r
\name{Gb.Choudhury}
\alias{Gb.Choudhury}
\title{Boundary Layer Conductance according to Choudhury & Monteith 1988}
\usage{
Gb.Choudhury(data, Tair = "Tair", pressure = "pressure", wind = "wind",
  ustar = "ustar", H = "H", leafwidth, LAI, zh, zr, d,
  stab_formulation = c("Dyer_1970", "Businger_1971"), Sc = NULL,
  Sc_name = NULL, constants = bigleaf.constants())
}
\arguments{
\item{data}{Data.frame or matrix containing all required variables}

\item{Tair}{Air temperature (degC)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{wind}{Wind speed at sensor height (m s-1)}

\item{ustar}{Friction velocity (m s-1)}

\item{H}{Sensible heat flux (W m-2)}

\item{leafwidth}{Leaf width (m)}

\item{LAI}{One-sided leaf area index}

\item{zh}{Canopy height (m)}

\item{zr}{Instrument (reference) height (m)}

\item{d}{Zero-plane displacement height (-), can be calculated using \code{roughness.parameters}}

\item{stab_formulation}{Stability correction function used (If \code{stab_correction = TRUE}).
Either \code{"Dyer_1970"} or \code{"Businger_1971"}.}

\item{Sc}{Optional: Schmidt number of additional quantities to be calculated}

\item{Sc_name}{Optional: Name of the additonal quantities, has to be of same length than 
\code{Sc_name}}

\item{constants}{k - von-Karman constant \cr
Sc_CO2 - Schmidt number for CO2 \cr 
Pr - Prandtl number (if \code{Sc} is provided)}
}
\value{
A data frame with the following columns:
 \item{Gb_h}{Boundary layer conductance for heat transfer (m s-1)}
 \item{Rb_h}{Boundary layer resistance for heat transfer (s m-1)}
 \item{kB_h}{kB-1 parameter for heat transfer}
 \item{Gb_Sc_name}{Boundary layer conductance for \code{Sc_name} (m s-1). Only added if \code{Sc_name} and 
                   \code{Sc_name} are provided}
}
\description{
A formulation for the canopy boundary layer conductance 
             for heat transfer according to Choudhury & Monteith 1988.
}
\details{
Boundary layer conductance according to Choudhury & Monteith 1988 is
         given by:
         
           \deqn{Gb_h = LAI((2a/\alpha)*sqrt(u(h)/w)*(1-exp(-\alpha/2)))}
         
         where u(zh) is the wind speed at the canopy surface, approximated from
         measured wind speed at sensor height zr and a wind extinction coefficient \eqn{\alpha}:
         
           \deqn{u(zh) = u(zr) / (exp(\alpha(zr/zh -1)))}.
         
         \eqn{\alpha} is modeled as an empirical relation to LAI (McNaughton & van den Hurk 1995):
         
           \deqn{\alpha = 4.39 - 3.97*exp(-0.258*LAI)}
         
         Gb (=1/Rb) for water vapor and heat are assumed to be equal in this package.
         Gb for other quantities x is calculated as (Hicks et al. 1987):
 
           \deqn{Gb_x = Gb / (Sc_x / Pr)^0.67}
 
         where Sc_x is the Schmidt number of quantity x, and Pr is the Prandtl number (0.71).
}
\examples{
## bulk canopy boundary layer resistance for a closed canopy (LAI=5) 
## with large leaves (leafwdith=0.1)            
df <- data.frame(Tair=25,pressure=100,wind=c(3,4,5),ustar=c(0.5,0.6,0.65),H=c(200,230,250))    
Gb.Choudhury(data=df,leafwidth=0.1,LAI=5,zh=25,d=17.5,zr=40)

## same conditions, but smaller leaves (leafwidth=0.01)
Gb.Choudhury(data=df,leafwidth=0.01,LAI=5,zh=25,d=17.5,zr=40) 

}
\references{
Choudhury, B. J., Monteith J.L., 1988: A four-layer model for the heat
            budget of homogeneous land surfaces. Q. J. R. Meteorol. Soc. 114, 373-398.
            
            McNaughton, K. G., Van den Hurk, B.J.J.M., 1995: A 'Lagrangian' revision of
            the resistors in the two-layer model for calculating the energy budget of a
            plant canopy. Boundary-Layer Meteorology 74, 261-288.
            
            Hicks, B.B., Baldocchi, D.D., Meyers, T.P., Hosker, J.R., Matt, D.R., 1987:
            A preliminary multiple resistance routine for deriving dry deposition velocities
            from measured quantities. Water, Air, and Soil Pollution 36, 311-330.
}
\seealso{
\code{\link{Gb.Thom}}, \code{\link{Gb.Su}}, \code{\link{aerodynamic.conductance}}
}
