% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge.R
\name{edge}
\alias{edge}
\title{Efficient Estimation of Bid-Ask Spreads from OHLC Prices}
\usage{
edge(open, high, low, close, na.rm = FALSE)
}
\arguments{
\item{open}{numeric vector of Open prices.}

\item{high}{numeric vector of High prices.}

\item{low}{numeric vector of Low prices.}

\item{close}{numeric vector of Close prices.}

\item{na.rm}{a \code{logical} value indicating whether \code{NA} values should be stripped before the computation proceeds.}
}
\value{
The spread estimate.
}
\description{
Implements an efficient estimation procedure of the bid-ask spread from Open, High, Low, and Close
prices as proposed in \href{https://www.ssrn.com/abstract=3892335}{Ardia, Guidotti, Kroencke (2021)}.
}
\details{
Prices must be sorted in ascending order of the timestamp.
}
\references{
Ardia, D., Guidotti E., & Kroencke T. A. (2021). Efficient Estimation of Bid-Ask Spreads from Open, High, Low, and Close Prices. 
Available at SSRN: \url{https://www.ssrn.com/abstract=3892335}
}
