% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crit_quant.R
\name{crit_quant}
\alias{crit_quant}
\title{Function of quantitative validation criteria}
\usage{
crit_quant(input_ent)
}
\arguments{
\item{input_ent}{input_ent is a dataframe with the list of main scientifics references generated by the principal_lister function}
}
\value{
The function return a list object with two dataframes with quantitative criteria that validate the list of main scientifics references
}
\description{
This function quantitatively validates the list of main scientific references obtained. The function input is a list object with the two dataframes generated by the principal_lister function. The crit_quant function returns a list of two dataframes with the quantitative criteria that validate the list of main scientific references obtained.
}
\examples{

#Call the principal_lister function
input_tam <- 100
file_db <- system.file("extdata","example_database.csv", package = "bibliorefer")
separator <- ","
input_date <- example_database(file_db, separator)
principal_refer <- principal_lister(input_date,input_tam)

#Call the crit_quant function
quant_validation <- crit_quant(principal_refer)
quant_validation[[1]]
quant_validation[[2]]

}
\references{
1 - Asymptotic Theory of Statistics and Probability. Anirban DasGupta. New York: Springer Science+Business Media, LLC, 2008.

2 - Quantitative science studies should be framed with middle-range theories and concepts from the social sciences Heinze, T.,  Jappe, A. Quantitative Science Studies, 1(3), pp. 983–992, 2020
}
