% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfMerge.R
\name{dfMerge}
\alias{dfMerge}
\title{Merging of Bibliographic data frames}
\usage{
dfMerge(M1, M2, Field = "TI", tol = 0.9)
}
\arguments{
\item{M1}{is the first bibliographic data frame.}

\item{M2}{is the second bibliographic data frame.}

\item{Field}{is a character object. It indicates one of the field tags used to match the two data frames. Field can be equal to one of this tags: TI (title), AB (abstract), UT (manuscript ID).}

\item{tol}{is a numeric value giving the minimum relative similarity to marge two manuscripts. Default value is \code{tol = 0.90}.}
}
\value{
the value returned from \code{dfMerge} is a data frame containing the merged data frames.
}
\description{
Merge two bibliographic data frames.
}
\details{
A bibliographic data frame is obtained by the converting function \code{\link{convert2df}}. 
It is a data matrix with cases corresponding to manuscripts and variables to Field Tag in the original SCOPUS and Thomson Reuters' ISI Web of Knowledge file.
The function merges two bibliographic data frames deleting duplicate manuscripts. 
Duplicate entries are identified through the generalized Levenshtein (edit) distance. 
Two manuscripts that have a similarity greater than \code{tol} argument are stored in the merged data frame only once.
}
\examples{
 
data(scientometrics)

M1=scientometrics[1:20,]

M2=scientometrics[10:30,]

mergedM <- dfMerge(M1, M2, Field = "TI", tol = 0.95)

dim(mergedM)


}
\seealso{
\code{\link{convert2df}} to import and convert an ISI or SCOPUS Export file in a bibliographic data frame.

\code{\link{biblioAnalysis}} function for bibliometric analysis.

\code{\link{summary}} to obtain a summary of the results.

\code{\link{plot}} to draw some useful plots of the results.
}

