% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_diag.R
\name{DiagMCMC}
\alias{DiagMCMC}
\title{Diagnose MCMC}
\usage{
DiagMCMC(data.MCMC, par.name, job.names, job.group,
  credible.region = 0.95, monochrome = TRUE,
  plot.colors = c("#495054", "#e3e8ea"))
}
\arguments{
\item{data.MCMC}{MCMC chains to diagnose}

\item{par.name}{parameter to analyze}

\item{job.names}{names of all parameters in analysis, Default: NULL}

\item{job.group}{for some hierarchical models with several layers of parameter names (e.g., latent and observed parameters), Default: NULL}

\item{credible.region}{summarize uncertainty by defining a region of most credible values (e.g., 95 percent of the distribution), Default: 0.95}

\item{monochrome}{logical, indicating whether or not to use monochrome colors, else use \link[bfw]{DistinctColors}, Default: TRUE}

\item{plot.colors}{range of color to use, Default: c("#495054", "#e3e8ea")}
}
\value{
list of diagnostic plots
}
\description{
MCMC convergence diagnostics
}
\seealso{
\code{\link[grDevices]{dev.new}},\code{\link[grDevices]{colorRampPalette}},\code{\link[grDevices]{recordPlot}},\code{\link[grDevices]{graphics.off}},\code{\link[grDevices]{dev.list}},\code{\link[grDevices]{dev.off}}
 \code{\link[graphics]{par}},\code{\link[graphics]{layout}},\code{\link[graphics]{plot.new}},\code{\link[graphics]{matplot}},\code{\link[graphics]{abline}},\code{\link[graphics]{text}},\code{\link[graphics]{points}},\code{\link[graphics]{mtext}}
 \code{\link[coda]{traceplot}},\code{\link[coda]{gelman.plot}},\code{\link[coda]{effectiveSize}}
 \code{\link[stats]{sd}},\code{\link[stats]{acf}},\code{\link[stats]{density}}
}
