% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backboinet.R
\name{get.oc.backboinet}
\alias{get.oc.backboinet}
\title{backboinet}
\usage{
get.oc.backboinet(
  target_T = 0.3,
  toxprob,
  target_E = 0.25,
  effprob,
  n.dose,
  startdose,
  ncohort,
  cohortsize,
  pT.saf = 0.6 * target_T,
  pT.tox = 1.4 * target_T,
  pE.saf = 0.6 * target_E,
  alpha.T1 = 0.5,
  alpha.E1 = 0.5,
  tau.T,
  tau.E,
  te.corr = 0.2,
  gen.event.time = "weibull",
  accrual,
  gen.enroll.time = "uniform",
  n.elimination = 6,
  stopping.npts = 12,
  suspend = 0,
  stopping.prob.T = 0.95,
  stopping.prob.E = 0.9,
  ppsi01 = 0,
  ppsi00 = 40,
  ppsi11 = 60,
  ppsi10 = 100,
  n.sim = 1000,
  seed.sim = 100
)
}
\arguments{
\item{target_T}{Target toxicity probability. The default value is
\code{target_T=0.3}. When observing 1 DLT out of 3 patients and the target
DLT rate is between 0.25 and 0.279, the decision is to stay at the current
dose due to a widely accepted practice.}

\item{toxprob}{Vector of true toxicity probability.}

\item{target_E}{The minimum required efficacy probability. The default value
is \code{target_E=0.25}.}

\item{effprob}{Vector of true efficacy probability.}

\item{n.dose}{Number of dose.}

\item{startdose}{Starting dose. The lowest dose is generally recommended.}

\item{ncohort}{Number of cohort.}

\item{cohortsize}{Cohort size.}

\item{pT.saf}{Highest toxicity probability that is deemed sub-therapeutic
such that dose-escalation should be pursued. The default value is
\code{pT.saf=target_T*0.6}.}

\item{pT.tox}{Lowest toxicity probability that is deemed overly toxic such
that dose de-escalation is needed. The default value is
\code{pT.tox=target_T*1.4}.}

\item{pE.saf}{Minimum probability deemed efficacious such that the dose
levels with less than delta1 are considered sub-therapeutic.
The default value is \code{pE.saf=target_E*0.6}.}

\item{alpha.T1}{Probability that toxicity event occurs in the late half of
toxicity assessment window. The default value is \code{alpha.T1=0.5}.}

\item{alpha.E1}{Probability that efficacy event occurs in the late half of
assessment window. The default value is \code{alpha.E1=0.5}.}

\item{tau.T}{Toxicity assessment windows (months).}

\item{tau.E}{Efficacy assessment windows (months).}

\item{te.corr}{Correlation between toxicity and efficacy probability,
specified as Gaussian copula parameter. The default value is
\code{te.corr=0.2}.}

\item{gen.event.time}{Method to generate the time to first toxicity and
efficacy outcome. Weibull distribution is used when
\code{gen.event.time ="weibull"}. Uniform distribution is used when
\code{gen.event.time="uniform"}.
The default value is \code{gen.event.time="weibull"}.}

\item{accrual}{Accrual rate (months) (patient accrual rate per month).}

\item{gen.enroll.time}{Method to generate enrollment time. Uniform
distribution is used when
\code{gen.enroll.time="uniform"}. Exponential distribution is used when
\code{gen.enroll.time="exponential"}. The default
value is \code{gen.enroll.time="uniform"}.}

\item{n.elimination}{a minimum sample size for dose elimination. If the number
of patients treated at the current dose reaches \code{n.elimination} and meet 
elimination dose level criteria, eliminate current dose level and higher doses 
when meet toxicity criteria and eliminate current dose level when meet efficacy
criteria. The default value is \code{n.elimination=6}.}

\item{stopping.npts}{Early study termination criteria for the number of
patients in the dose-escalation and backfill cohorts. If the number of
patients at the current dose reaches this criteria and the same dose level
is recommended as the next dose level, the study is terminated.
The default value is \code{stopping.npts=12}.}

\item{suspend}{The suspension rule that holds off the decision on dose
allocation for the dose-escalation cohort until sufficient toxicity
information is available. For example, setting as 0.33 which means one-third
of the patients had not completed the toxicity evaluation at the current dose
level in the dose escalation cohort. The default value \code{suspend=0}
essentially turns off this type of suspending rule, that is all patients
should complete the toxicity evaluation at the current dose level in the dose
escalation cohort}

\item{stopping.prob.T}{Early study termination criteria for toxicity,
taking a value between 0 and 1. If the posterior probability that toxicity
outcome is less than the target toxicity probability (\code{target_T}) is
larger than this criteria, the dose levels are eliminated from the study.
The default value is \code{stopping.prob.T=0.95}.}

\item{stopping.prob.E}{Early study termination criteria for efficacy,
taking a value between 0 and 1. If the posterior probability that efficacy
outcome is less than the minimum efficacy probability (\code{target_E}) is
larger than this criteria, the dose levels are eliminated from the study.
The default value is \code{stopping.prob.E=0.90}.}

\item{ppsi01}{Score for toxicity=yes and efficacy=no in utility defined by
scoring.The default value is \code{psi01=0}.}

\item{ppsi00}{Score for toxicity=no and efficacy=no in utility defined by
scoring. The default value is \code{psi00=40}.}

\item{ppsi11}{Score for toxicity=yes and efficacy=yes in utility defined by
scoring. The default value is \code{psi11=60}.}

\item{ppsi10}{Score for toxicity=no and efficacy=yes in utility defined by
scoring. The default value is \code{psi10=100}.}

\item{n.sim}{Number of simulated trial. The default value is
\code{n.sim=1000}.}

\item{seed.sim}{Seed for random number generator. The default value is
\code{seed.sim=100}.}
}
\value{
The \code{backboinet} returns a list containing the following components:
\item{toxprob}{True toxicity probability.}
\item{effprob}{True efficacy probability.}
\item{phi}{Target toxicity probability.}
\item{delta}{Target efficacy probability.}
\item{lambda1}{Lower toxicity boundary in dose escalation/de-escalation.}
\item{lambda2}{Upper toxicity boundary in dose escalation/de-escalation.}
\item{eta1}{Lower efficacy boundary in dose escalation/de-escalation.}
\item{tau.T}{Toxicity assessment windows (months).}
\item{tau.E}{Efficacy assessment windows (months).}
\item{suspend}{The suspension rule that holds off the decision on dose
allocation for the dose-escalation cohort until sufficient toxicity
information is available.}
\item{accrual}{Accrual rate (months) (patient accrual rate per month).}
\item{n.patient}{Average number of patients who were treated at each dose
level}
\item{n.bpatient}{Average number of back filled patients who were treated
at each dose level}
\item{n.tox.patient}{Average number of patients who experienced toxicity at 
each dose level}
\item{n.eff.patient}{Average number of patients who experienced efficacy at 
each dose level}
\item{prop.select}{Percentage of times that each dose level was selected as
optimal biological dose.}
\item{prop.stop}{Percentage of times that the study was terminated.}
\item{duration}{Expected study duration (months)}
\item{totaln}{Total patients}
\item{data.obs.n}{Record the number of patients in each dose level within the
simulations during the trial}
\item{obd}{Record the optimal dose in each simulation during the trial}
\item{backfilltimes}{Record how may times we back-filled during the trial}
\item{backfillcount}{Record the number of back-filled patients in dose level
within the simulations during the trial}
\item{PCS}{The percentage of trials that the optimal dose was correctly
selected.}
\item{PCA}{The percentage of patients that were correctly allocated to the
optimal dose.}
\item{PTS}{The percentage of toxic doses selection.}
\item{PTA}{The percentage of patients who were allocated to toxic doses.}
}
\description{
Obtain the operating characteristics of the backfill bayesian
optimal interval design using efficacy and toxicity outcomes for dose
optimization within fixed scenarios
}
\details{
The \code{backboinet} is a function which generates the operating
characteristics of the backfill bayesian optimal interval design using
efficacy and toxicity outcomes for dose optimization by a simulation study.
Users can specify a variety of study settings to simulate studies. The
operating characteristics of the design are summarized by the percentage of
times that each dose level was selected as optimal biological dose and the
average number of patients who were treated at each dose level. The
percentage of times that the study was terminated and the expected study
duration are also provided.
}
\examples{

target_T=0.3
target_E=0.25
toxprob=c(0.03,0.05,0.2,0.22,0.45)
effprob=c(0.05,0.1,0.5,0.68,0.7)

get.oc.backboinet(target_T=target_T, toxprob=toxprob,target_E=target_E,
effprob=effprob,n.dose=5,startdose=1,ncohort=10,cohortsize=3,
pT.saf=0.6 * target_T,pT.tox = 1.4 * target_T,pE.saf = 0.6 * target_E,
alpha.T1=0.5,alpha.E1=0.5,tau.T=1,tau.E=1,te.corr=0.2,
gen.event.time="weibull",accrual=3,gen.enroll.time="uniform",n.elimination=6,
stopping.npts=12,suspend=0,stopping.prob.T=0.95,stopping.prob.E=0.90,
ppsi01=0,ppsi00=40,ppsi11=60,ppsi10=100,n.sim=2,seed.sim=100)

}
\references{
BF-BOIN-ET: A backfill Bayesian optimal interval design using
efficacy and toxicity outcomes for dose optimization.
}
