% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exTime.R
\name{exTime}
\alias{exTime}
\title{Time to run examples}
\usage{
exTime(topic = NA, package = NA, echo = FALSE, elapsed = FALSE,
  imagefile = TRUE, quiet = FALSE, ...)
}
\arguments{
\item{topic}{Character string: the online \code{\link{help}} topic
of which the examples should be run.}

\item{package}{Charstring: installed and loaded package from which all examples should be run.}

\item{echo}{Show the R input when sourcing? DEFAULT: FALSE}

\item{elapsed}{Return *only* the third element (total elapsed time)? DEFAULT: FALSE}

\item{imagefile}{Reroute graphics to \code{\link{pdf}} device?
Will \code{\link{message}} the \code{\link{tempfile}}
location if quiet=FALSE.  DEFAULT: TRUE}

\item{quiet}{Suppress warnings with both \code{\link{suppressWarnings}} and
\code{\link{suppressMessages}},
also \code{\link{capture.output}} for str and cat results
as well as setting \code{pboptions(type="none")} if \code{pbapply} is available.}

\item{\dots}{Further arguments to \code{\link{example}}, especially
\code{run.dontrun}, \code{run.donttest} and \code{package},
but NOT \code{character.only} and \code{ask}}
}
\value{
Time used as per \code{\link{system.time}}
}
\description{
Time the execution of examples. Useful in package development to identify functions taking much time.
}
\examples{
exTime("plot")
exTime("yearSample", quiet=TRUE)
exTime(yearSample) # does NOT work, gives NULL and warning
exTime("yearSample", elapsed=TRUE, quiet=TRUE)
exTime("addFade", elapsed=TRUE, quiet=TRUE, run.dontrun=TRUE, run.donttest=TRUE)

## this takes quite some time if done for all functions in a package:
\dontrun{
times <- exTime(package="rdwd")
as.matrix(sort(times))
system2("open", tempdir()) # to view the pdf graphics created by exTime

# times <- exTime(package="rdwd", run.dontrun=FALSE)
}

}
\seealso{
\code{\link{example}}, \code{\link{system.time}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2016
}
\keyword{documentation}
\keyword{utilities}
