% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runAxis.R
\name{runAxis}
\alias{runAxis}
\title{Label axis with typical running times}
\usage{
runAxis(t = 3 * 60, int1 = 10, int2 = 5, side = 1, linarg = NULL, ...)
}
\arguments{
\item{t}{Maximum time in minutes}

\item{int1}{Primary interval (for labels)}

\item{int2}{Secondary interval (for lines)}

\item{side}{Side of the plot to draw \code{\link{axis}} (1,2,3,4 = bottom, left, top, right)}

\item{linarg}{List of arguments passed to \code{\link{abline}}}

\item{\dots}{Further arguments passed to \code{\link{axis}}}
}
\value{
List with the positions and labels
}
\description{
Label a numerical axis (in minutes) with time units that are typical for running times (10 sec intervals)
}
\examples{
plot(1:200, xaxt="n")
runAxis(t=200, int1=20, int2=10)

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jun 2016
}
\seealso{
\code{\link{logAxis}}, \code{\link{monthAxis}}
}
\keyword{aplot}

