% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_param}
\alias{create_param}
\title{General function to create a parameter.}
\usage{
create_param(name, id, ...)
}
\arguments{
\item{name}{the parameters' name. Valid
names can be found in \code{\link{get_param_names}}}

\item{id}{the parameter's ID}

\item{...}{specific parameter parameters}
}
\value{
a parameter
}
\description{
General function to create a parameter.
}
\note{
Prefer using the
  named functions
  \code{\link{create_alpha_param}},
  \code{\link{create_beta_param}},
  \code{\link{create_clock_rate_param}},
  \code{\link{create_kappa_1_param}},
  \code{\link{create_kappa_2_param}},
  \code{\link{create_lambda_param}},
  \code{\link{create_m_param}},
  \code{\link{create_mean_param}},
  \code{\link{create_mu_param}},
  \code{\link{create_rate_ac_param}},
  \code{\link{create_rate_ag_param}},
  \code{\link{create_rate_at_param}},
  \code{\link{create_rate_cg_param}},
  \code{\link{create_rate_ct_param}},
  \code{\link{create_rate_gt_param}},
  \code{\link{create_s_param}},
  \code{\link{create_scale_param}},
  and \code{\link{create_sigma_param}}
}
\examples{
  # Create an alpha parameter
  alpha_param <- create_alpha_param()

  # Use the parameter in a distribution
  beta_distr <- create_beta_distr(
    alpha = alpha_param
  )

  # Use the distribution to create a BEAST2 input file
  create_beast2_input_file(
    input_filenames = get_fasta_filename(),
    "create_alpha_param.xml",
    tree_priors = create_yule_tree_prior(
      birth_rate_distr = beta_distr
    )
  )
  testit::assert(file.exists("create_alpha_param.xml"))
}
\author{
Richel J.C. Bilderbeek
}
