% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_input_filename.R
\name{check_input_filename_validity}
\alias{check_input_filename_validity}
\title{Checks the input filename.
Will stop if there is a problem with the input filename.}
\usage{
check_input_filename_validity(beast2_options)
}
\arguments{
\item{beast2_options}{a set of BEAST2 options,
that are the R equivalent of the BEAST2 command-line options,
as can be created by \link{create_beast2_options}}
}
\value{
nothing. Will call \code{\link{stop}} if the input file is invalid
}
\description{
Checks the input filename.
Will stop if there is a problem with the input filename.
}
\examples{
check_empty_beaustier_folders()

if (is_beast2_installed()) {
  check_input_filename_validity(
    create_beast2_options(
      input_filename = get_beastier_path("2_4.xml")
    )
  )
}
check_empty_beaustier_folders()
}
\author{
Richèl J.C. Bilderbeek
}
