% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_analyte.R
\name{identify_assay_analyte}
\alias{identify_assay_analyte}
\alias{identify_legendplex_analyte}
\alias{identify_cba_analyte}
\alias{identify_macsplex_analyte}
\title{Identify multiplex assay analytes}
\usage{
identify_legendplex_analyte(df, .analytes, .method_args, .data = NULL)

identify_cba_analyte(
  df,
  .analytes,
  .method_args,
  .trim_fs = NULL,
  .parameter_fs = NULL,
  .data = NULL
)

identify_macsplex_analyte(
  df,
  .analytes,
  .method_args,
  .trim_fs = NULL,
  .parameter_fs = NULL,
  .data = NULL
)
}
\arguments{
\item{df}{A tidy data.frame.}

\item{.analytes}{A vector or list giving the IDs of the analytes. The
\strong{order} is important and must match the expected order of analytes.}

\item{.method_args}{A list giving the parameters passed on to \code{identify_analyte()}.}

\item{.data}{Deprecated. Use \code{df}.}

\item{.trim_fs}{A numeric between 0 and 1, giving the fraction of points to
remove from the forward side scatter.}

\item{.parameter_fs}{A character giving the names of the forward and side
scatter parameters.}
}
\value{
A data.frame
}
\description{
Convenience functions to identify analytes in different multiplex systems.
}
\details{
These functions wraps around the process of:
\itemize{
\item Trim or subset on forward side scatter
\item Identifying analytes. For LEGENDplex in both bead groups
}

If the forward side scatter events are not trimmed, the function is equivalent
to call \code{\link[=identify_analyte]{identify_analyte()}} with CBA or MACSPlex data.
}
\section{Analytes}{

The parameter \code{.analytes} is either a simple vector with the IDs or, in the
case of the LEGENDplex system, a list giving the IDs of analytes among the groups A and B.

A list for the LEGENDplex system might look like this:\preformatted{  list(A = c("A1", "A2"),
       B = c("B1", "B2"))
}

The \strong{order} of analyte IDs is important and must match the expected order of analytes.
}

\section{Method arguments}{

The parameter \code{.method_args} is a list of key-value pairs passed to \code{\link[=identify_analyte]{identify_analyte()}}.
}

\examples{
\dontrun{
library(beadplexr)
library(dplyr)
data("lplex")
df <- lplex[[1]]

panel_info <- load_panel(.panel_name = "Human Growth Factor Panel (13-plex)")

args_ident_analyte <- list(fs = list(.parameter = c("FSC-A", "SSC-A"),
                                     .column_name = "Bead group",
                                     .trim = 0.1,
                                     .method = "clara"),
                           analytes = list(.parameter = "FL6-H",
                                           .column_name = "Analyte ID",
                                           .trim = 0,
                                           .method = "clara"))

annot_events <- identify_legendplex_analyte(df = df,
                                            .analytes = panel_info$analytes,
                                            .method_args = args_ident_analyte)

annot_events \%>\% facs_plot(.beads = "Bead group")

annot_events \%>\%
  filter(`Bead group` == "A") \%>\%
  facs_plot(.x = "FL2-H", .y = "FL6-H", .beads = "Analyte ID")

annot_events \%>\%
  filter(`Bead group` == "B") \%>\%
  facs_plot(.x = "FL2-H", .y = "FL6-H", .beads = "Analyte ID")
}
\dontrun{
library(beadplexr)
data(simplex)

df <- simplex[["cba"]]

analytes <- vector("list", 30) \%>\% setNames(as.character(c(1:30)))

args_ident_analyte <- list(.parameter = c("APC", "APC-Cy7"),
                           .column_name = "Analyte ID",
                           .trim = 0.1,
                           .method = "clara")
annot_events <- identify_cba_analyte(df = df,
                     .analytes = analytes,
                     .method_args = args_ident_analyte)

annot_events \%>\% facs_plot(.x = "FSC", .y = "SSC")

annot_events \%>\%
  facs_plot(.x = "APC", .y = "APC-Cy7", .beads = "Analyte ID")

annot_events <- identify_cba_analyte(df = df,
                     .analytes = analytes,
                     .method_args = args_ident_analyte,
                     .trim_fs = 0.1,
                     .parameter_fs = c("FSC", "SSC"))

annot_events \%>\% facs_plot(.x = "FSC", .y = "SSC", .beads = "Bead events")

# Looks strange because some true beads events have randomly been placed far
# from the center in the forward-side scatter when the data was created
annot_events \%>\%
  facs_plot(.x = "APC", .y = "APC-Cy7", .beads = "Analyte ID")
}
\dontrun{
library(beadplexr)
data(simplex)

df <- simplex[["mplex"]]
analytes <- vector("list", 10) \%>\% setNames(as.character(c(1:10)))

args_ident_analyte <- list(.parameter = c("FITC", "PE"),
                           .column_name = "Analyte ID",
                           .trim = 0.1,
                           .method = "clara")

annot_events <- identify_macsplex_analyte(df = df,
                                     .analytes = analytes,
                                     .method_args = args_ident_analyte)

annot_events \%>\% facs_plot(.x = "FSC", .y = "SSC")

annot_events \%>\%
  facs_plot(.x = "FITC", .y = "PE", .beads = "Analyte ID")

annot_events <- identify_macsplex_analyte(df = df,
                                     .analytes = analytes,
                                     .method_args = args_ident_analyte,
                                     .trim_fs = 0.1,
                                     .parameter_fs = c("FSC", "SSC"))

annot_events \%>\% facs_plot(.x = "FSC", .y = "SSC", .beads = "Bead events")
# Looks strange because some true beads events have randomly been placed far
# from the center in the forward-side scatter when the data was created
annot_events \%>\%
  facs_plot(.x = "FITC", .y = "PE", .beads = "Analyte ID")
}
}
