% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrigraph.R
\name{distrigraph}
\alias{distrigraph}
\title{Distribution graphs}
\usage{
distrigraph(indf, ptype = NA, ...)
}
\arguments{
\item{indf}{input data frame containing biodiversity data set}

\item{ptype}{Feature to represent. Accepted values are "species", "cell" and 
"efforts" (year)}

\item{...}{any additional parameters for the \code{\link{plot}} function.}
}
\description{
Build plots dispalying distribution of biodiversity records among 
user-defined features.
}
\details{
The main use of this function is to create record histograms according to
different features of the data set. For example, one might want to see the 
evolution of records by year, or by species. This function enables easy 
access to such plots.
}
\examples{
\dontrun{
 distrigraph(inat,ptype="cell",col="tomato")
 distrigraph(inat,ptype="species",ylab="Species")
 distrigraph(inat,ptype="efforts",col="red")
 distrigraph(inat,ptype="efforts",col="red",type="s")
}
}
