% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointness.R
\name{jointness}
\alias{jointness}
\title{Calculation of of the jointness measures}
\usage{
jointness(bma_list, measure = "HCGHM", rho = 0.5, round = 3)
}
\arguments{
\item{bma_list}{bma object (the result of the bma function)}

\item{measure}{Parameter for choosing the measure of jointness: \cr
HCGHM - for Hofmarcher et al. (2018) measure; \cr
LS - for Ley & Steel (2007) measure; \cr
DW - for Doppelhofer & Weeks (2009) measure; \cr
PPI - for posterior probability of including both variables.}

\item{rho}{The parameter "rho" (\eqn{\rho}) to be used in HCGHM jointness measure (default rho = 0.5). Works only if HCGHM measure is chosen (Hofmarcher et al. 2018).}

\item{round}{Parameter indicating the decimal place to which the jointness measures should be rounded (default round = 3).}
}
\value{
A table with jointness measures for all the pairs of regressors used in the analysis. Parameter "above" indicates what model prior is used for the values ABOVE the diagonal, and parameter "below" indicates what model prior is used for the values BELOW the diagonal.
}
\description{
This function calculates four types of the jointness measures based on the posterior model probabilities calculated using binomial and binomial-beta model prior. The four measures are: \cr
\enumerate{
\item HCGHM - for Hofmarcher et al. (2018) measure; \cr
\item LS - for Ley & Steel (2007) measure; \cr
\item DW - for Doppelhofer & Weeks (2009) measure; \cr
\item PPI - for posterior probability of including both variables. \cr
The measures under binomial model prior will appear in a table above the diagonal, and the measure calculated under binomial-beta model prior below the diagonal. \cr
\cr
REFERENCES \cr
Doppelhofer G, Weeks M (2009) Jointness of growth determinants. Journal of Applied Econometrics., 24(2), 209-244. doi: 10.1002/jae.1046 \cr
Hofmarcher P, Crespo Cuaresma J, Grün B, Humer S, Moser M (2018) Bivariate jointness measures in Bayesian Model Averaging: Solving the conundrum. Journal of Macroeconomics, 57, 150-165. doi: 10.1016/j.jmacro.2018.05.005 \cr
Ley E, Steel M (2007) Jointness in Bayesian variable selection with applications to growth regression. Journal of Macroeconomics, 29(3), 476-493. doi: 10.1016/j.jmacro.2006.12.002
}
}
\examples{
\donttest{
library(magrittr)

data_prepared <- bdsm::economic_growth[, 1:6] \%>\%
  bdsm::feature_standardization(
    excluded_cols = c(country, year, gdp)
  ) \%>\%
  bdsm::feature_standardization(
    group_by_col  = year,
    excluded_cols = country,
    scale         = FALSE
  )

bma_results <- bma(
  model_space = bdsm::small_model_space,
  df          = data_prepared,
  round       = 3,
  dilution    = 0
)

jointness_table <- jointness(bma_results, measure = "HCGHM", rho = 0.5, round = 3)
}
}
