% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEM_likelihood.R
\name{SEM_likelihood}
\alias{SEM_likelihood}
\title{Likelihood for the SEM model}
\usage{
SEM_likelihood(
  params,
  data,
  timestamp_col,
  entity_col,
  dep_var_col,
  lin_related_regressors = NULL,
  per_entity = FALSE,
  exact_value = TRUE
)
}
\arguments{
\item{params}{Parameters describing the model. Can be either a vector or a
list with named parameters. See 'Details'}

\item{data}{Data for the likelihood computations. Can be either a list of
matrices or a dataframe. If the dataframe, additional parameters are
required to build the matrices within the function.}

\item{timestamp_col}{Column which determines time stamps. For now only
natural numbers can be used.}

\item{entity_col}{Column which determines entities (e.g. countries, people)}

\item{dep_var_col}{Column with dependent variable}

\item{lin_related_regressors}{Which subset of columns should be used as
regressors for the current model. In other words \code{regressors} are the
total set of regressors and \code{lin_related_regressors} are the ones for
which linear relation is not set to zero for a given model.}

\item{per_entity}{Whether to compute overall likelihood or a vector of
likelihoods with per entity value}

\item{exact_value}{Whether the exact value of the likelihood should be
computed (\code{TRUE}) or just the proportional part (\code{FALSE}).
Currently \code{TRUE} adds: 1. a normalization constant coming from Gaussian
distribution, 2. a term disappearing during likelihood simplification in
Likelihood-based Estimation of Dynamic Panels with Predetermined Regressors
by Moral-Benito (see Appendix A.1). The latter happens when transitioning
from equation (47) to equation (48), in step 2: the term \code{trace(HG_22)} is
dropped, because it can be assumed to be constant from Moral-Benito
perspective. To get the exact value of the likelihood we have to take this
term into account.}
}
\value{
The value of the likelihood for SEM model (or a part of interest of the
likelihood)
}
\description{
Likelihood for the SEM model
}
\details{
The \code{params} argument is a list that should contain the following
components:

\code{alpha} scalar value which determines linear dependence on lagged
dependent variable

\code{phi_0} scalar value which determines linear dependence on the value
of dependent variable at the lowest time stamp

\code{err_var} scalar value which determines classical error component
(Sigma11 matrix, sigma_epsilon^2)

\code{dep_vars} double vector of length equal to the number of time stamps
(i.e. time stamps greater than or equal to the second lowest time stamp)

\code{beta} double vector which determines the linear dependence on
regressors different than the lagged dependent variable; The vector should
have length equal to the number of regressors.

\code{phi_1} double vector which determines the linear dependence on
initial values of regressors different than the lagged dependent variable;
The vector should have length equal to the number of regressors.

\code{phis} double vector which together with \code{psis} determines upper
right and bottom left part of the covariance matrix; The vector should have
length equal to the number of regressors times number of time stamps minus 1,
i.e. \code{regressors_n * (periods_n - 1)}

\code{psis} double vector which together with \code{psis} determines upper
right and bottom left part of the covariance matrix; The vector should have
length equal to the number of regressors times number of time stamps minus 1
times number of time stamps divided by 2, i.e.
\code{regressors_n * (periods_n - 1) * periods_n / 2}
}
\examples{
set.seed(1)
df <- data.frame(
  entities = rep(1:4, 5),
  times = rep(seq(1960, 2000, 10), each = 4),
  dep_var = stats::rnorm(20), a = stats::rnorm(20), b = stats::rnorm(20)
)
df <-
  feature_standardization(df, timestamp_col = times, entity_col = entities)
SEM_likelihood(0.5, df, times, entities, dep_var)
}
