% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_draws.R
\name{spread_draws}
\alias{spread_draws}
\title{Spread MCMC chain draws to data.frame on a wide format}
\usage{
spread_draws(mod, ..., transformed = FALSE)
}
\arguments{
\item{mod}{An object of class "plm0", "plm", "gplm0" or "gplm".}

\item{...}{Any number of character vectors containing valid names of parameters in the model or "rating_curve" and "rating_curve_mean". Also accepts "latent_parameters" and "hyperparameters".}

\item{transformed}{A boolean value determining whether the output is to be represented on the transformed scale used for sampling in the MCMC chain or the original scale. Defaults to FALSE.}
}
\value{
A data frame with columns:
\describe{
  \item{\code{chain}}{The chain number.}
  \item{\code{iter}}{The iteration number.}
  \item{\code{param}}{The parameter name.}
  \item{\code{value}}{The parameter value.}
}
}
\description{
Useful to convert MCMC chain draws of particular parameters or output from the model object to a wide format for further data wrangling
}
\examples{
\donttest{
 data(krokfors)
 set.seed(1)
 plm0.fit <- plm0(formula=Q~W,data=krokfors,num_cores=2)
 hyp_samples <- spread_draws(plm0.fit,'hyperparameters')
 head(hyp_samples)
 rating_curve_samples <- spread_draws(plm0.fit,'rating_curve','rating_curve_mean')
 head(rating_curve_samples)
}
}
\references{
Hrafnkelsson, B., Sigurdarson, H., Rögnvaldsson, S., Jansson, A. Ö., Vias, R. D., and Gardarsson, S. M. (2022). Generalization of the power-law rating curve using hydrodynamic theory and Bayesian hierarchical modeling, Environmetrics, 33(2):e2711. doi: https://doi.org/10.1002/env.2711
}
\seealso{
\code{\link{plm0}}, \code{\link{plm}}, \code{\link{gplm0}}, \code{\link{gplm}} for further information on parameters
}
