% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtractorEml.R
\name{ExtractorEml}
\alias{ExtractorEml}
\title{Class to handle email files with eml extension}
\description{
This class inherits from the \code{\link{Instance}} class and
implements the functions of extracting the text and the date from an eml type
file.
}
\section{Details}{

The way to indicate which part to choose in the email, when is a multipart email,
is through the \strong{"extractorEML.mpaPartSelected"}
field of \code{\link{bdpar.Options}} variable.
}

\section{Note}{

To be able to use this class it is necessary to have Python installed.
}

\section{Inherit}{

This class inherits from \code{\link{Instance}} and implements the
\code{obtainSource} and \code{obtainDate} abstracts functions.
}

\seealso{
\code{\link{bdpar.Options}}, \code{\link{ExtractorSms}},
\code{\link{ExtractorTwtid}}, \code{\link{ExtractorYtbid}},
\code{\link{Instance}}
}
\section{Super class}{
\code{\link[bdpar:Instance]{bdpar::Instance}} -> \code{ExtractorEml}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtractorEml-new}{\code{ExtractorEml$new()}}
\item \href{#method-ExtractorEml-obtainDate}{\code{ExtractorEml$obtainDate()}}
\item \href{#method-ExtractorEml-obtainSource}{\code{ExtractorEml$obtainSource()}}
\item \href{#method-ExtractorEml-getPartSelectedOnMPAlternative}{\code{ExtractorEml$getPartSelectedOnMPAlternative()}}
\item \href{#method-ExtractorEml-setPartSelectedOnMPAlternative}{\code{ExtractorEml$setPartSelectedOnMPAlternative()}}
\item \href{#method-ExtractorEml-toString}{\code{ExtractorEml$toString()}}
\item \href{#method-ExtractorEml-clone}{\code{ExtractorEml$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addBanPipes"><a href='../../bdpar/html/Instance.html#method-Instance-addBanPipes'><code>bdpar::Instance$addBanPipes()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addFlowPipes"><a href='../../bdpar/html/Instance.html#method-Instance-addFlowPipes'><code>bdpar::Instance$addFlowPipes()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="addProperties"><a href='../../bdpar/html/Instance.html#method-Instance-addProperties'><code>bdpar::Instance$addProperties()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="checkCompatibility"><a href='../../bdpar/html/Instance.html#method-Instance-checkCompatibility'><code>bdpar::Instance$checkCompatibility()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getBanPipes"><a href='../../bdpar/html/Instance.html#method-Instance-getBanPipes'><code>bdpar::Instance$getBanPipes()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getData"><a href='../../bdpar/html/Instance.html#method-Instance-getData'><code>bdpar::Instance$getData()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getDate"><a href='../../bdpar/html/Instance.html#method-Instance-getDate'><code>bdpar::Instance$getDate()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getFlowPipes"><a href='../../bdpar/html/Instance.html#method-Instance-getFlowPipes'><code>bdpar::Instance$getFlowPipes()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getNamesOfProperties"><a href='../../bdpar/html/Instance.html#method-Instance-getNamesOfProperties'><code>bdpar::Instance$getNamesOfProperties()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getPath"><a href='../../bdpar/html/Instance.html#method-Instance-getPath'><code>bdpar::Instance$getPath()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getProperties"><a href='../../bdpar/html/Instance.html#method-Instance-getProperties'><code>bdpar::Instance$getProperties()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getSource"><a href='../../bdpar/html/Instance.html#method-Instance-getSource'><code>bdpar::Instance$getSource()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="getSpecificProperty"><a href='../../bdpar/html/Instance.html#method-Instance-getSpecificProperty'><code>bdpar::Instance$getSpecificProperty()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="invalidate"><a href='../../bdpar/html/Instance.html#method-Instance-invalidate'><code>bdpar::Instance$invalidate()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="isInstanceValid"><a href='../../bdpar/html/Instance.html#method-Instance-isInstanceValid'><code>bdpar::Instance$isInstanceValid()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="isSpecificProperty"><a href='../../bdpar/html/Instance.html#method-Instance-isSpecificProperty'><code>bdpar::Instance$isSpecificProperty()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setData"><a href='../../bdpar/html/Instance.html#method-Instance-setData'><code>bdpar::Instance$setData()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setDate"><a href='../../bdpar/html/Instance.html#method-Instance-setDate'><code>bdpar::Instance$setDate()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setProperties"><a href='../../bdpar/html/Instance.html#method-Instance-setProperties'><code>bdpar::Instance$setProperties()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setSource"><a href='../../bdpar/html/Instance.html#method-Instance-setSource'><code>bdpar::Instance$setSource()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="Instance" data-id="setSpecificProperty"><a href='../../bdpar/html/Instance.html#method-Instance-setSpecificProperty'><code>bdpar::Instance$setSpecificProperty()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorEml-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorEml-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{ExtractorEml}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$new(path, PartSelectedOnMPAlternative = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. Path of the eml file.}

\item{\code{PartSelectedOnMPAlternative}}{A \code{\link{character}} value. Configuration to read
the eml files. If it is NULL, checks if is defined in the
\strong{"extractorEML.mpaPartSelected"} field of \emph{\link{bdpar.Options}}
variable.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorEml-obtainDate"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorEml-obtainDate}{}}}
\subsection{Method \code{obtainDate()}}{
Obtains the date of the eml file. Calls the function
\emph{read_emails} and obtains the date of the file indicated in the path
and then transforms it into the generic date format, that is
"\%a \%b \%d \%H:\%M:\%S \%Z \%Y" (Example: "Thu May 02 06:52:36 UTC 2013").
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$obtainDate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorEml-obtainSource"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorEml-obtainSource}{}}}
\subsection{Method \code{obtainSource()}}{
Obtains the source of the eml file. Calls the function
\emph{read_emails} and obtains the source of the file indicated in the
path. In addition, it initializes the data with the initial source.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$obtainSource()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorEml-getPartSelectedOnMPAlternative"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorEml-getPartSelectedOnMPAlternative}{}}}
\subsection{Method \code{getPartSelectedOnMPAlternative()}}{
Gets of \emph{PartSelectedOnMPAlternative} variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$getPartSelectedOnMPAlternative()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of \emph{PartSelectedOnMPAlternative} variable.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorEml-setPartSelectedOnMPAlternative"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorEml-setPartSelectedOnMPAlternative}{}}}
\subsection{Method \code{setPartSelectedOnMPAlternative()}}{
Gets of \code{PartSelectedOnMPAlternative} variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$setPartSelectedOnMPAlternative(PartSelectedOnMPAlternative)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{PartSelectedOnMPAlternative}}{A \code{\link{character}} value. The
new value of \emph{PartSelectedOnMPAlternative} variable.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorEml-toString"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorEml-toString}{}}}
\subsection{Method \code{toString()}}{
Returns a \code{\link{character}} representing the instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$toString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{\link{Instance}} \code{\link{character}} representation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtractorEml-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtractorEml-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtractorEml$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
