% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindUserNamePipe.R
\docType{class}
\name{FindUserNamePipe}
\alias{FindUserNamePipe}
\title{Class to find and/or remove the users on the data field of an Instance}
\usage{
FindUserNamePipe
}
\description{
This class is responsible of detecting the existing use names in the
\strong{data} field of each \code{\link{Instance}}. Identified user names are
stored inside the \strong{userName} field of \code{\link{Instance}} class.
Moreover if required, is able to perform inline user nanme removement.
}
\section{Constructor}{

\preformatted{
FindUserNamePipe$new(propertyName = "userName",
                     alwaysBeforeDeps = list(),
                     notAfterDeps = list())
}

\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
}
}
}
}

\section{Details}{

The regular expressions indicated in the \code{userPattern}
variable are used to identify user names.
}

\section{Note}{

\code{\link{FindUserNamePipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{PipeGeneric}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain/remove the name users.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance, removeUser = TRUE)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
\item{\strong{removeUser:}}{
(\emph{logical}) indicates if the users are removed.
}
}
}
}
}

\item{\bold{findUserName:}}{
finds the name users in the data.
\itemize{
\item{\emph{Usage:}}{
\code{findHashtag(data)}
}
\item{\emph{Value:}}{
list with users names found.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text to search the user names.
}
}
}
}
}

\item{\bold{removeUserName:}}{
removes the users in the data.
\itemize{
\item{\emph{Usage:}}{
\code{removeUserName(data)}
}
\item{\emph{Value:}}{
the data with name users removed.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{data:}}{
(\emph{character}) text to remove the user names.
}
}
}
}
}
}
}

\section{Public fields}{

\itemize{
\item{\bold{userPattern:}}{
 (\emph{character}) regular expression to detect users.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{PipeGeneric}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
