% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TeeCSVPipe.R
\docType{class}
\name{TeeCSVPipe}
\alias{TeeCSVPipe}
\title{Class to handle a CSV with the properties field of the preprocessed Instance}
\usage{
TeeCSVPipe
}
\description{
Complete a CSV with the properties of the preprocessed \code{\link{Instance}}.
}
\section{Constructor}{

\preformatted{
TeeCSVPipe$new(propertyName = "",
               alwaysBeforeDeps = list(),
               notAfterDeps = list())
}
\itemize{
\item{\emph{Arguments}}{
\itemize{
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
}
}
}
}

\section{Details}{

The path to save the properties have to indicate in the configuration file.

The way to indicate is the following:

\strong{[CSVPath]}

outPutTeeCSVPipePath = <<out_put_TeeCSVPipe_path>>
}

\section{Inherit}{

This class inherits from \code{\link{PipeGeneric}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
completes the CSV with the preprocessed \code{\link{Instance}}.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance, withData = TRUE, withSource = TRUE)}
}
\item{\emph{Value:}}{
the \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
\item{\strong{withData:}}{
(\emph{logical}) indicate if the data is added to CSV.
}
\item{\strong{withSource:}}{
(\emph{logical}) indicate if the source is added to CSV.
}
}
}
}
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{FindUserNamePipe}},
         \code{\link{GuessDatePipe}}, \code{\link{GuessLanguagePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{PipeGeneric}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{ToLowerCasePipe}}
}
