% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{posteriorDiscard.GaussianNIW}
\alias{posteriorDiscard.GaussianNIW}
\title{Update a "GaussianNIW" object with sample sufficient statistics}
\usage{
\method{posteriorDiscard}{GaussianNIW}(obj, ss, w = NULL, ...)
}
\arguments{
\item{obj}{A "GaussianNIW" object.}

\item{ss}{Sufficient statistics of x. In Gaussian-NIW case the sufficient statistic of sample x is a object of type "ssGaussian", it can be  generated by the function sufficientStatistics().}

\item{w}{Sample weights,default NULL.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the gamma stored in "obj" will be updated with the information in "ss".
}
\description{
For the model structure:
     \deqn{mu,Sigma|m,k,v,S \sim NIW(m,k,v,S)}
     \deqn{x|mu,Sigma \sim Gaussian(mu,Sigma)}
Where NIW() is the Normal-Inverse-Wishart distribution, Gaussian() is the Gaussian distribution. See \code{?dNIW} and \code{dGaussian} for the definitions of these distribution.\cr
Contrary to posterior(), this function will update (m,k,v,S) by removing the information of observed samples x. The model structure and prior parameters are stored in a "GaussianNIW" object, the prior parameters in this object will be updated after running this function.
}
\examples{
## generate some random Gaussian samples
x <- rGaussian(1000,mu = c(1,1),Sigma = matrix(c(1,0.5,0.5,3),2,2))
w <- runif(1000)
## add information to 'obj' then remove them one by one
obj <- GaussianNIW(gamma=list(m=c(0.2,3),k=1,v=2,S=diag(2)))
ss <- sufficientStatistics_Weighted(obj = obj,x=x,w=w,foreach = TRUE)
for(i in 1L:length(ss)) posterior(obj = obj,ss=ss[[i]])
obj
for(i in 1L:length(ss)) posteriorDiscard(obj = obj,ss=ss[[i]])
obj
## add information to 'obj' then remove them as a whole
obj <- GaussianNIW(gamma=list(m=c(0.2,3),k=1,v=2,S=diag(2)))
ssAll <- sufficientStatistics_Weighted(obj = obj,x=x,w=w,foreach = FALSE)
posterior(obj = obj,ss = ssAll)
obj
posteriorDiscard(obj = obj,ss = ssAll)
obj
}
\references{
Murphy, Kevin P. "Conjugate Bayesian analysis of the Gaussian distribution." def 1.22 (2007): 16.

Gelman, Andrew, et al. "Bayesian Data Analysis Chapman & Hall." CRC Texts in Statistical Science (2004).
}
\seealso{
\code{\link{GaussianNIW}},\code{\link{posterior.GaussianNIW}}
}
