% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{rNIW}
\alias{rNIW}
\title{Random number generation for Normal-Inverse-Wishart (NIW) distribution.}
\usage{
rNIW(m, k, v, S)
}
\arguments{
\item{m}{numeric, mean of mu.}

\item{k}{numeric, precision of mu.}

\item{v}{numeric, degree of freedom of Sigma.}

\item{S}{numeric, a symmetric positive definite scale matrix of Sigma, S is proportional to E(Sigma).}
}
\value{
A list of two list(mu,Sigma), where 'mu' is a numeric vector, the Gaussian sample; 'Sigma' is a symmetric positive definite matrix, the Inverse-Wishart sample.
}
\description{
Generate a NIW sample.For a random vector mu, and a random matrix Sigma, the density function is defined as:
   \deqn{sqrt(2 pi^p |Sigma/k|)^{-1} exp(-1/2 (mu-m )^T (Sigma/k)^{-1} (mu-m)) (2^{(v p)/2} Gamma_p(v/2) |S|^{-v/2})^{-1} |Sigma|^{(-v-p-1)/2} exp(-1/2 tr(Sigma^{-1} S))}
Where p is the dimension of mu and Sigma.
}
\examples{
rNIW(m=runif(3),k=0.001,v=5,S=crossprod(matrix(rnorm(15),5,3)))
}
\references{
O'Hagan, Anthony, and Jonathan J. Forster. Kendall's advanced theory of statistics, volume 2B: Bayesian inference. Vol. 2. Arnold, 2004.

MARolA, K. V., JT KBNT, and J. M. Bibly. Multivariate analysis. AcadeInic Press, Londres, 1979.
}
\seealso{
\code{\link{dNIW}}
}
