% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{MAP.GaussianGaussian}
\alias{MAP.GaussianGaussian}
\title{Maximum A Posteriori (MAP) estimate of a "GaussianGaussian" object}
\usage{
\method{MAP}{GaussianGaussian}(obj, ...)
}
\arguments{
\item{obj}{A "GaussianGaussian" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric vector, the MAP estimate of "mu".
}
\description{
Generate the MAP estimate of mu in following model structure:
     \deqn{x \sim Gaussian(mu,Sigma)}
     \deqn{mu \sim Gaussian(m,S)}
Where Sigma is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} for the definition of Gaussian distribution.\cr
The model structure and prior parameters are stored in a "GaussianGaussian" object. \cr
The MAP estimates are:
\itemize{
  \item (mu_MAP) = argmax p(mu|m,S,x,Sigma)
}
}
\examples{
obj <- GaussianGaussian(gamma=list(Sigma=matrix(c(2,1,1,2),2,2),m=c(0.2,0.5),S=diag(2)))
x <- rGaussian(100,c(0,0),Sigma = matrix(c(2,1,1,2),2,2))
ss <- sufficientStatistics(obj=obj,x=x,foreach = FALSE)
## update prior into posterior
posterior(obj = obj,ss = ss)
## get the MAP estimate of mu
MAP(obj)
}
\references{
Gelman, Andrew, et al. Bayesian data analysis. CRC press, 2013.
}
\seealso{
\code{\link{GaussianGaussian}}
}
