% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{rPosteriorPredictive.CatHDP2}
\alias{rPosteriorPredictive.CatHDP2}
\title{Generate random samples from the posterior predictive distribution of a "CatHDP2" object}
\usage{
\method{rPosteriorPredictive}{CatHDP2}(obj, n = 1L, m, j, ...)
}
\arguments{
\item{obj}{A "CatHDP2" object.}

\item{n}{integer, number of samples.}

\item{m}{integer, group label.}

\item{j}{integer, subgroup label.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
integer, the categorical samples.
}
\description{
Generate random samples from the posterior predictive distribution of the following structure:
     \deqn{G_m |eta ~ DP(eta,U), m = 1:M}
     \deqn{G_mj|gamma ~ DP(gamma,G_m), j = 1:J_m}
     \deqn{pi_mj|G_mj,alpha ~ DP(alpha,G_mj)}
     \deqn{z|pi_mj ~ Categorical(pi_mj)}
     \deqn{k|z,G_mj ~ Categorical(G_mj), if z is a sample from the base measure G_mj}
     \deqn{u|k,G_m ~ Categorical(G_m), if k is a sample from the base measure G_m}
where DP(eta,U) is a Dirichlet Process on positive integers, eta is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(gamma,G_m) is a Dirichlet Process on integers with concentration parameter gamma and base measure G_m. DP(alpha,G_mj) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_mj. Categorical() is the Categorical distribution. See \code{dCategorical} for the definition of the Categorical distribution. \cr
In the case of CatHDP2, u, z and k can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatHDP2" object. \cr
Posterior predictive is a distribution of u,z,k|alpha,gamm,eta,U,G_mj,G_m.
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatHDP2}}, \code{\link{dPosteriorPredictive.CatHDP2}}
}
