% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{sufficientStatistics_Weighted.CatDP}
\alias{sufficientStatistics_Weighted.CatDP}
\title{Weighted sufficient statistics of a "CatDP" object}
\usage{
\method{sufficientStatistics_Weighted}{CatDP}(obj, x, w, foreach = FALSE, ...)
}
\arguments{
\item{obj}{A "CatDP" object.}

\item{x}{integer, the elements of the vector must all greater than 0, the samples of a Categorical distribution.}

\item{w}{numeric, sample weights}

\item{foreach}{logical, specifying whether to return the sufficient statistics for each observation. Default FALSE.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
An object of class "ssCatDP", the sufficient statistics of a set of categorical samples. Or an integer vector same as x if foreach=TRUE.
}
\description{
For following model structure: \cr
     pi|alpha ~ DP(alpha,U) \cr
     x|pi ~ Categorical(pi) \cr
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process, it is an uniform distribution on all positive integers. \cr
In the case of CatDP, x can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatDP" object. \cr
The sufficient statistics of a set of samples x is the effective counts of the unique positive integers.
}
\examples{
x <- sample(1L:10L,size = 4,replace = TRUE)
obj <- CatDP()
w <- runif(4)
## return an object of class "ssCatDP" contains the weighted counts of each unique integer
sufficientStatistics_Weighted(obj=obj,x=x,w=w)
## return x itself, no matter what w is
sufficientStatistics_Weighted(obj=obj,x=x,w=w,foreach = TRUE)
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatDP}}, \code{\link{sufficientStatistics.CatDP}}
}
