% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{posteriorDiscard.CatDP}
\alias{posteriorDiscard.CatDP}
\title{Update a "CatDP" object with sample sufficient statistics}
\usage{
\method{posteriorDiscard}{CatDP}(obj, ss, w = NULL, ...)
}
\arguments{
\item{obj}{A "CatDP" object.}

\item{ss}{Sufficient statistics of x. In Categorical-DP case the sufficient statistic of sample x can either be an object of type "ssCatDP" generated by sufficientStatistics(), or x itself(if x is a integer vector with all positive values).}

\item{w}{Sample weights,default NULL.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the model stored in "obj" will be updated with the information in "ss".
}
\description{
For the model structure: \cr
     pi|alpha ~ DP(alpha,U) \cr
     x|pi ~ Categorical(pi) \cr
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process, it is an uniform distribution on all positive integers. \cr
In the case of CatDP, x can only be positive integers. \cr
Contrary to posterior(), this function will update the prior knowledge by removing the information of observed samples x. The model structure and prior parameters are stored in a "CatDP" object, the prior parameters in this object will be updated after running this function.
}
\examples{
## generate some integer samples
x <- sample(1L:10L,size = 40,replace = TRUE)
obj <- CatDP()
ss <- sufficientStatistics(obj=obj,x=x)
posterior(obj = obj,ss = ss)
obj2 <- CatDP(objCopy = obj)            #create obj2 contains the sames info as obj
obj3 <- CatDP(objCopy = obj)            #create obj3 contains the sames info as obj
## discard by samples
posteriorDiscard(obj = obj,ss = x)
## or discard by samples, one by one
for(xx in x) posteriorDiscard(obj = obj2,ss = xx)
## or discard by sufficient statistics
posteriorDiscard(obj = obj3,ss = ss)
## obj, obj2 and obj3 should be the same:
obj
obj2
obj3
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatDP}},\code{\link{posterior.CatDP}}
}
