% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{MPE.CatDP}
\alias{MPE.CatDP}
\title{Mean Posterior Estimate(MPE) of a "CatDP" object}
\usage{
\method{MPE}{CatDP}(obj, ...)
}
\arguments{
\item{obj}{A "CatDP" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric.
}
\description{
Generate the MPE estimate of "pi" in following model structure: \cr
     pi|alpha ~ DP(alpha,U) \cr
     x|pi ~ Categorical(pi) \cr
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process, it is an uniform distribution on all positive integers. \cr
In the case of CatDP, x can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatDP" object. \cr
MPE is pi_MPE = E(pi|alpha,x), E() is the expectation function.
}
\examples{
x <- sample(1L:10L,size = 40,replace = TRUE)
obj <- CatDP()
posterior(obj = obj,ss = x)
MPE(obj)
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatDP}}
}
