% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerCmaes.R
\name{mlr_optimizers_cmaes}
\alias{mlr_optimizers_cmaes}
\alias{OptimizerCmaes}
\title{Optimization via Covariance Matrix Adaptation Evolution Strategy}
\description{
\code{OptimizerCmaes} class that implements CMA-ES. Calls
\code{\link[adagio:cmaes]{adagio::pureCMAES()}} from package \CRANpkg{adagio}.
}
\section{Dictionary}{

This \link{Optimizer} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_optimizers} or with the associated sugar function \code{\link[=opt]{opt()}}:\preformatted{mlr_optimizers$get("cmaes")
opt("cmaes")
}
}

\section{Parameters}{

\describe{
\item{\code{par}}{\code{numeric()}}
\item{\code{sigma}}{\code{numeric(1)}}
}

For the meaning of the control parameters, see \code{\link[adagio:cmaes]{adagio::pureCMAES()}}. Note
that we have removed all control parameters which refer to the termination of
the algorithm and where our terminators allow to obtain the same behavior.
}

\examples{
library(paradox)
library(data.table)

domain = ParamSet$new(list(ParamDbl$new("x", lower = -1, upper = 1)))

search_space = ParamSet$new(list(ParamDbl$new("x", lower = -1, upper = 1)))

codomain = ParamSet$new(list(ParamDbl$new("y", tags = "minimize")))

objective_function = function(xs) {
  list(y = as.numeric(xs)^2)
}

objective = ObjectiveRFun$new(fun = objective_function,
                              domain = domain,
                              codomain = codomain)
terminator = trm("evals", n_evals = 2)
instance = OptimInstanceSingleCrit$new(objective = objective,
                             search_space = search_space,
                             terminator = terminator)

optimizer = opt("cmaes", par = 1)

# Modifies the instance by reference
optimizer$optimize(instance)

# Returns best scoring evaluation
instance$result

# Allows access of data.table of full path of all evaluations
instance$archive$data()
}
\section{Super class}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{OptimizerCmaes}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{OptimizerCmaes$new()}}
\item \href{#method-clone}{\code{OptimizerCmaes$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format">}\href{../../bbotk/html/Optimizer.html#method-format}{\code{bbotk::Optimizer$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="optimize">}\href{../../bbotk/html/Optimizer.html#method-optimize}{\code{bbotk::Optimizer$optimize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print">}\href{../../bbotk/html/Optimizer.html#method-print}{\code{bbotk::Optimizer$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerCmaes$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerCmaes$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
