% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlk.R
\name{mlestimate}
\alias{mlestimate}
\title{Maximum likelihood estimate}
\usage{
mlestimate(
  xi,
  weights = NULL,
  qJ = NULL,
  method = "pseudo",
  L = NULL,
  lambda = 1e-05,
  lambdah = 0,
  symmetrize = TRUE,
  eps = 0.9,
  nprint = 100,
  itmax = 10000,
  tolerance = 1e-05,
  verbose = 1,
  prior.count = 1,
  naive = FALSE,
  lz.half = FALSE
)
}
\arguments{
\item{xi}{Data matrix; expected to be numeric with elements ranging from 
zero to positive integral upper bound \code{L-1}.}

\item{weights}{Frequency vector of number of times each row of \code{xi} 
is to be repeated. If \code{NULL}, defaults to 1. Expected
to be non-negative integers.}

\item{qJ}{Matrix of logicals indicating which predictor pairs are
interacting. If \code{NULL}, all are allowed.}

\item{method}{\code{c('pseudo','mf')} for pseudo-likelihood maximization or
mean field inference.}

\item{L}{Vector of number of factor levels in each predictor. If
\code{NULL}, will be inferred from \code{xi}.}

\item{lambda}{Vector of L2 regularization parameters for 
\code{method = 'pseudo'}. Applies to interaction parameters \code{J}.}

\item{lambdah}{L2 parameters for \code{h} in \code{'pseudo'}.
If \code{NULL}, it is set equal to \code{lambda}.
\code{lambdah = 0} will free \code{h} from penalization.}

\item{symmetrize}{Enforce the symmetry of interaction parameters by
taking mean values of the matrix and its trace:
\eqn{J_{ij}^{(y)}(x_1,x_2)=J_{ji}^{(y)}(x_2,x_1)}.}

\item{eps}{Vector of regularization parameters for \code{mf}. Must be
within the range of \eqn{\epsilon \in [0,1]}.}

\item{nprint}{Frequency of printing iteration progress under \code{'pseudo'}.}

\item{itmax}{Maximum number of iterations for \code{'pseudo'}.}

\item{tolerance}{Upper bound for fractional changes in pseduo-likelihood
values before termiating iteration in \code{'pseudo'}.}

\item{verbose}{Verbosity level.}

\item{prior.count}{Prior count for \code{method = 'mf'} to reduce
numerical instability.}

\item{naive}{Naive Bayes inference. Equivalent to \code{method = 'mf'} together
with \code{eps = 0}.}

\item{lz.half}{Divide interaction term in approximation to \eqn{\ln Z_{iy}}
in \code{'pseudo'}.}
}
\value{
List of inferred parameters \code{h} and \code{J}. See 
       \code{\link{bbl}} for parameter structures.
}
\description{
Perform inference of bias and interaction parameters for a single response group
}
\details{
Given numeric data matrix, either pseudo-likelihood
of mean-field theory is used to find the maximum likelihood estimate
of bias \code{h} and interaction \code{J} parameters. Normally
called by \code{\link{bbl}} rather than directly.
}
\examples{
set.seed(535)
predictors <- list()
for(i in 1:5) predictors[[i]] <- c('a','c','g','t')
par <- randompar(predictors)
par
xi <- sample_xi(nsample=5000, predictors=predictors, h=par$h, J=par$J,
                code_out=TRUE)
head(xi)
ps <- mlestimate(xi=xi, method='pseudo', lambda=0)
ps$h
ps$J[[1]]
mf <- mlestimate(xi=xi, method='mf', eps=0.9)
plot(x=unlist(par$h), y=unlist(ps$h), xlab='True', ylab='Inferred')
segments(x0=-2, x1=2, y0=-2, y1=2, lty=2)
points(x=unlist(par$J), y=unlist(ps$J), col='red')
points(x=unlist(par$h), y=unlist(mf$h), col='blue')
points(x=unlist(par$J), y=unlist(mf$J), col='green')
}
