% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contr.orthonorm.R
\name{contr.orthonorm}
\alias{contr.orthonorm}
\alias{contr.bayes}
\title{Orthonormal Contrast Matrices for Bayesian Estimation}
\usage{
contr.orthonorm(n, contrasts = TRUE, sparse = FALSE)
}
\arguments{
\item{n}{a vector of levels for a factor, or the number of levels.}

\item{contrasts}{a logical indicating whether contrasts should be
    computed.}

\item{sparse}{logical indicating if the result should be sparse
    (of class \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}}), using
    package \href{https://CRAN.R-project.org/package=Matrix}{\pkg{Matrix}}.}
}
\value{
A \code{matrix} with n rows and k columns, with k=n-1 if contrasts is
\code{TRUE} and k=n if contrasts is \code{FALSE}.
}
\description{
Returns a design or model matrix of orthonormal contrasts such that the
marginal prior on all effects is identical (see 'Details'). Implementation
from Singmann & Gronau's \href{https://github.com/bayesstuff/bfrms/}{\code{bfrms}},
following the description in Rouder, Morey, Speckman, & Province (2012, p.
363).
\cr\cr
Though using this factor coding scheme might obscure the interpretation of
parameters, it is essential for correct estimation of Bayes factors for
contrasts and order restrictions of multi-level factors (where \code{k>2}). See
info on specifying correct priors for factors with more than 2 levels in
\href{https://easystats.github.io/bayestestR/articles/bayes_factors.html}{the Bayes factors vignette}.
}
\details{
When \code{contrasts = FALSE}, the returned contrasts are equivalent to
\code{contr.treatment(, contrasts = FALSE)}, as suggested by McElreath (also known
as one-hot encoding).
\subsection{Setting Priors}{

It is recommended to set 0-centered, identically-scaled priors on the dummy
coded variables produced by this method. These priors then represent the
distance the mean of one of the levels might have from the overall mean.
\subsection{Contrasts}{

This method guarantees that any set of contrasts between the \emph{k} groups will
have the same multivariate prior regardless of level order; However,
different contrasts within a set contrasts can have different univariate
prior shapes/scales.
\cr\cr
For example the contrasts \code{A - B} will have the same prior as \code{B - C}, as
will \code{(A + C) - B} and \code{(B + A) - C}, but \code{A - B} and \code{(A + C) - B} will
differ.
}

}
}
\examples{
contr.orthonorm(2) # Q_2 in Rouder et al. (2012, p. 363)

contr.orthonorm(5) # equivalent to Q_5 in Rouder et al. (2012, p. 363)

## check decomposition
Q3 <- contr.orthonorm(3)
Q3 \%*\% t(Q3) ## 2/3 on diagonal and -1/3 on off-diagonal elements
}
\references{
\itemize{
\item McElreath, R. (2020). Statistical rethinking: A Bayesian course with
examples in R and Stan. CRC press.
\item Rouder, J. N., Morey, R. D., Speckman, P. L., & Province, J. M. (2012).
Default Bayes factors for ANOVA designs. \emph{Journal of Mathematical
Psychology}, 56(5), 356-374. https://doi.org/10.1016/j.jmp.2012.08.001
}
}
