% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_helper_functions.R
\name{df_to_list}
\alias{df_to_list}
\title{Convert data frame to a list by animal ID}
\usage{
df_to_list(dat, ind)
}
\arguments{
\item{dat}{A data frame containing the data for each animal ID.}

\item{ind}{character. The name of the column storing the animal IDs.}
}
\value{
A list where each element stores the data for a separate animal ID.
}
\description{
Converts an object of class \code{data.frame} to a list where each element is
a separate animal ID. This function prepares the data for further analysis
and when mapping other functions onto the data for separate animal IDs.
}
\examples{
#load data
data(tracks)

#convert to list
dat.list<- df_to_list(dat = tracks, ind = "id")


}
