% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-ssm_reg.R
\name{ssm_stan_fit_impl}
\alias{ssm_stan_fit_impl}
\title{Low-Level ARIMA function for translating modeltime to forecast}
\usage{
ssm_stan_fit_impl(
  x,
  y,
  trend = FALSE,
  damped = FALSE,
  seasonal = FALSE,
  period = 0,
  genT = FALSE,
  chains = 4,
  iter = 2000,
  warmup = iter/2,
  adapt.delta = 0.9,
  tree.depth = 10,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A dataframe of xreg (exogenous regressors)}

\item{y}{A numeric vector of values to fit}

\item{trend}{a boolean value to specify a trend local level model. By default is FALSE.}

\item{damped}{a boolean value to specify a damped trend local level model. By default is FALSE.}

\item{seasonal}{a boolean value to specify a seasonal local level model.}

\item{period}{an integer specifying the periodicity of the time series.}

\item{genT}{a boolean value to specify for a generalized t-student SSM model.}

\item{chains}{An integer of the number of Markov Chains chains to be run, by default 4 chains are run.}

\item{iter}{An integer of total iterations per chain including the warm-up, by default the number of iterations are 2000.}

\item{warmup}{A positive integer specifying number of warm-up (aka burn-in) iterations. This also specifies the number of iterations used for step-size adaptation, so warm-up samples should not be used for inference. The number of warmup should not be larger than iter and the default is iter/2.}

\item{adapt.delta}{An optional real value between 0 and 1, the thin of the jumps in a HMC method. By default is 0.9}

\item{tree.depth}{An integer of the maximum depth of the trees evaluated during each iteration. By default is 10.}

\item{seed}{An integer with the seed for using when predicting with the model.}

\item{...}{Additional arguments passed to \code{forecast::Arima}}
}
\value{
A modeltime model
}
\description{
Low-Level ARIMA function for translating modeltime to forecast
}
