% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_posterior_draws.R
\name{get_posterior_draws}
\alias{get_posterior_draws}
\title{Get posterior samples from lm_b object}
\usage{
get_posterior_draws(object, n_draws = 10000, seed = 1)
}
\arguments{
\item{object}{Object of class lm_b}

\item{n_draws}{integer.  Number of posterior draws to obtain.}

\item{seed}{integer.  Always set your seed!!!}
}
\value{
matrix of posterior draws
}
\description{
Get posterior samples from lm_b object
}
\examples{
\donttest{
set.seed(2025)
N = 500
test_data <-
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5])
test_data$outcome <-
  rnorm(N,-1 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e")) )
fit1 <-
  lm_b(outcome ~ x1 + x2 + x3,
       data = test_data)
pdraws <-
  get_posterior_draws(fit1)
  }


}
