% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{IFA_Mode_Jumper_MixedResponses}
\alias{IFA_Mode_Jumper_MixedResponses}
\title{Exploratory Factor Analysis of Mixed-Type Responses}
\usage{
IFA_Mode_Jumper_MixedResponses(
  Y,
  M,
  gamma,
  Ms,
  sdMH,
  bounds,
  burnin,
  chain_length = 10000L
)
}
\arguments{
\item{Y}{A N by J matrix of mixed-type item responses.}

\item{M}{An interger specifying the number of factors.}

\item{gamma}{The value of the mode-jumping tuning parameter. Man and Culpepper (2020) used gamma = 0.5.}

\item{Ms}{model indicator where 0 = "bounded", 1 = "continuous", 2 = "binary", >2 = "ordinal".}

\item{sdMH}{A J vector of tuning parameters for the Cowles (1996) Metropolis-Hastings sampler for ordinal data latent thresholds.}

\item{bounds}{A J by 2 matrix denoting the min and max variable values. Note that bounds are only used for variable j if element j of Ms is zero.}

\item{burnin}{Number of burn-in iterations to discard.}

\item{chain_length}{The total number of iterations (burn-in + post-burn-in).}
}
\value{
A list that contains nsamples = chain_length - burnin array draws from the posterior distribution:
\itemize{
\item \code{LAMBDA}: A J by M by nsamples array of sampled loading matrices on the standardized metric.
\item \code{PSIs}: A J by nsamples matrix of vector of variable uniquenesses on the standardized metric.
\item \code{ROW_OUT}: A matrix of sampled row indices of founding variables for mode-jumping algorithm.
\item \code{THRESHOLDS}: An array of sampled thresholds.
\item \code{INTERCEPTS}: Sampled variable thresholds on the standardized metric.
\item \code{ACCEPTED}: Acceptance rates for mode-jumping Metropolis-Hastings (MH) steps.
\item \code{MHACCEPT}: A J vector of acceptance rates for item threshold parameters. Note that binary items have an acceptance rate of zero, because MH steps are never performed.
\item \code{LAMBDA_unst}: An array of unstandardized loadings.
\item \code{PSIs_inv_unst}: A matrix of unstandardized uniquenesses.
\item \code{THRESHOLDS_unst}: Unstandardized thresholds.
\item \code{INTERCEPTS_unst}: Unstandardized intercepts.
}
}
\description{
Implement the Man and Culpepper (2020) mode-jumping algorithm to factor analyze mixed-type response data. Missing values should be specified as a non-numeric value such as NA.
}
\references{
Cowles, M. K. (1996), Accelerating Monte Carlo Markov chain convergence for cumulative link generalized linear models," Statistics and Computing, 6, 101-111.

Man, A. & Culpepper, S. A. (2020). A mode-jumping algorithm for Bayesian factor analysis. Journal of the American Statistical Association, doi:10.1080/01621459.2020.1773833.
}
\author{
Albert X Man, Steven Andrew Culpepper
}
