% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesRecon-package.R
\docType{package}
\name{bayesRecon-package}
\alias{bayesRecon}
\alias{bayesRecon-package}
\title{bayesRecon: Probabilistic Reconciliation via Conditioning}
\description{
Provides methods for probabilistic reconciliation of hierarchical forecasts of time series. The available methods include analytical Gaussian reconciliation (Corani et al., 2021) \doi{10.1007/978-3-030-67664-3_13}, MCMC reconciliation of count time series (Corani et al., 2022) \doi{10.48550/arXiv.2207.09322}, Bottom-Up Importance Sampling (Zambon et al., 2022) \doi{10.48550/arXiv.2210.02286}.
}
\section{Learn more}{


To learn more about \code{bayesRecon}, start with the vignettes: \code{browseVignettes(package = "bayesRecon")}
}

\section{Main functions}{


The package implements reconciliation via conditioning for probabilistic forecasts of hierarchical time series. The main functions are
\itemize{
\item \code{\link[=reconc_gaussian]{reconc_gaussian()}}: analytical reconciliation of Gaussian base forecasts;
\item \code{\link[=reconc_BUIS]{reconc_BUIS()}}: reconciliation of any probabilistic base forecast via importance sampling;
this is the recommended option for non-Gaussian base forecasts;
\item \code{\link[=reconc_MCMC]{reconc_MCMC()}}: reconciliation of probabilistic discrete base forecasts via Markov Chain Monte Carlo.
}
}

\section{Utility functions}{

\itemize{
\item \code{\link[=temporal_aggregation]{temporal_aggregation()}}: temporal aggregation of a given time series object of class \link[stats]{ts};
\item \code{\link[=get_reconc_matrices]{get_reconc_matrices()}}: aggregation and summing matrices for a temporal hierarchy of time series from user-selected list of aggregation levels.
}
}

\references{
Corani, G., Azzimonti, D., Augusto, J.P.S.C., Zaffalon, M. (2021). \emph{Probabilistic Reconciliation of Hierarchical Forecast via Bayes' Rule}. In: Hutter, F., Kersting, K., Lijffijt, J., Valera, I. (eds) Machine Learning and Knowledge Discovery in Databases. ECML PKDD 2020. Lecture Notes in Computer Science(), vol 12459. Springer, Cham. \doi{10.1007/978-3-030-67664-3_13}.

Corani, G., Azzimonti, D., Rubattu, N. (2023). \emph{Probabilistic reconciliation of count time series}. \doi{10.1016/j.ijforecast.2023.04.003}.

Zambon, L., Azzimonti, D. & Corani, G. (2024). \emph{Efficient probabilistic reconciliation of forecasts for real-valued and count time series}. \doi{10.1007/s11222-023-10343-y}.

Zambon, L., Agosto, A., Giudici, P., Corani, G. (2023). \emph{Properties of the reconciled distributions for Gaussian and count forecasts}. \doi{10.48550/arXiv.2303.15135}.
}
\author{
\strong{Maintainer}: Dario Azzimonti \email{dario.azzimonti@gmail.com} (\href{https://orcid.org/0000-0001-5080-3061}{ORCID})

Authors:
\itemize{
  \item Nicolò Rubattu \email{nicolo.rubattu@idsia.ch} (\href{https://orcid.org/0000-0002-2703-1005}{ORCID})
  \item Lorenzo Zambon \email{lorenzo.zambon@idsia.ch} (\href{https://orcid.org/0000-0002-8939-993X}{ORCID})
  \item Giorgio Corani \email{giorgio.corani@idsia.ch} (\href{https://orcid.org/0000-0002-1541-8384}{ORCID})
}

}
\keyword{internal}
