% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduceResults.R
\name{reduceResultsList}
\alias{reduceResultsList}
\alias{reduceResultsDataTable}
\title{Apply Functions on Results}
\usage{
reduceResultsList(ids = NULL, fun = NULL, ..., missing.val,
  reg = getDefaultRegistry())

reduceResultsDataTable(ids = NULL, fun = NULL, ..., fill = FALSE,
  missing.val, reg = getDefaultRegistry())
}
\arguments{
\item{ids}{[\code{\link[base]{data.frame}} or \code{integer}]\cr
A \code{\link[base]{data.frame}} (or \code{\link[data.table]{data.table}})
with a column named \dQuote{job.id}.
Alternatively, you may also pass a vector of integerish job ids.
If not set, defaults to the return value of \code{\link{findDone}}.}

\item{fun}{[\code{function}]\cr
Function to apply to each result. The result is passed unnamed as first argument. If \code{NULL}, the identity is used.
If the function has the formal argument \dQuote{job}, the \code{\link{Job}}/\code{\link{Experiment}} is also passed to the function.}

\item{...}{[\code{ANY}]\cr
Additional arguments passed to to function \code{fun}.}

\item{missing.val}{[\code{ANY}]\cr
Value to impute as result for a job which is not finished.
If not provided and a result is missing, an exception is raised.}

\item{reg}{[\code{\link{Registry}}]\cr
Registry. If not explicitly passed, uses the default registry (see \code{\link{setDefaultRegistry}}).}

\item{fill}{[\code{logical(1)}]\cr
In \code{reduceResultsDataTable}: This flag is passed down to
\code{\link[data.table]{rbindlist}} which is used to convert the results
to a \code{\link[data.table]{data.table}}.}
}
\value{
\code{reduceResultsList} returns a list of the results in the same order as the provided ids.
  \code{reduceResultsDataTable} returns a \code{\link[data.table]{data.table}} with columns \dQuote{job.id} and additional result columns
  created via \code{\link[data.table]{rbindlist}}, sorted by \dQuote{job.id}.
}
\description{
Applies a function on the results of your finished jobs and thereby collects
them in a \code{\link[base]{list}} or \code{\link[data.table]{data.table}}.
The later requires the provided function to return a list (or \code{data.frame}) of scalar values.
See \code{\link[data.table]{rbindlist}} for features and limitations of the aggregation.

If not all jobs are terminated, the respective result will be \code{NULL}.
}
\note{
If you have thousands of jobs, disabling the progress bar (\code{options(batchtools.progress = FALSE)})
can significantly increase the performance.
}
\examples{
tmp = makeRegistry(file.dir = NA, make.default = FALSE)
batchMap(function(x) x^2, x = 1:10, reg = tmp)
submitJobs(reg = tmp)
waitForJobs(reg = tmp)
reduceResultsList(fun = sqrt, reg = tmp)
}
\seealso{
\code{\link{reduceResults}}

Other Results: \code{\link{batchMapResults}},
  \code{\link{loadResult}}, \code{\link{reduceResults}}
}
