% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-panels.R
\name{plot_panels}
\alias{plot_panels}
\title{Plot three-panel figures for nested partially-latent model results}
\usage{
plot_panels(
  DIR_NPLCM,
  slices = "all",
  bg_color = list(BrS = "lavenderblush", SS = "mistyrose", pie = "antiquewhite"),
  select_latent = NULL,
  exact = TRUE,
  SS_upperlimit = 1,
  eti_upperlimit = 1,
  silent = TRUE,
  ref_eti0 = NULL,
  is_plot = TRUE
)
}
\arguments{
\item{DIR_NPLCM}{File path to the folder containing posterior samples}

\item{slices}{DEFAULT is "all" - to plot all measurements; Otherwise, one can
specify a list: \code{list(MBS=c(1,3),MSS=1)} means to plot the 1st and
3rd slice of BrS measurements and 1st of SS measurement.}

\item{bg_color}{A list with names "BrS", "SS", "pie" to specify background colors.
The current default is \code{list(BrS = "lavenderblush", SS = "mistyrose",  pie="antiquewhite")}. If no background is intended, specify as NULL or for a particular
measurement, e.g., \code{BrS = NULL}.}

\item{select_latent}{a vector of character strings representing latent status. It is used for
just plotting a subset of latent status. For example, you can specify \code{select_latent = "HINF"}
to plot all latent status information relevant to \code{"HINF"}.}

\item{exact}{Default is \code{TRUE} to use \code{select_latent} as exact names of causes. If you want to
specify a name and plot all single or combo causes with that name, specify it to be \code{FALSE}.}

\item{SS_upperlimit}{The upper limit of horizontal bar for the silver-standard
subpanel (the middle panel). The default value is .25.}

\item{eti_upperlimit}{The upper limit of horizontal bar for the etiology
posterior subpanel (the rightmost panel). The default value is .4}

\item{silent}{Default is TRUE to not print any warning messages; FALSE otherwise.}

\item{ref_eti0}{reference quantiles and means; a list: pEti_ref_q, pEti_ref_mean_ord}

\item{is_plot}{default to \code{TRUE} for plotting only; set to \code{FALSE} if to get summary.}
}
\value{
A figure with two or three columns (if \code{is_plot=TRUE}); otherwise, it
provide posterior summaries of Etiology information to
used by \code{\link[=print.summary.nplcm.no_reg]{print.summary.nplcm.no_reg()}}
}
\description{
\code{plot_panels()} visualizes the model outputs for communicating how the data inform final
latent disease status (etiology). It works for singleton or combo etiologies.
}
\details{
Missing data for BrS or SS are dropped when calculating observed measurement
positive rates
}
\seealso{
Other visualization functions: 
\code{\link{plot.nplcm}()},
\code{\link{plot_BrS_panel}()},
\code{\link{plot_SS_panel}()},
\code{\link{plot_check_common_pattern}()},
\code{\link{plot_check_pairwise_SLORD}()},
\code{\link{plot_etiology_regression}()},
\code{\link{plot_etiology_strat}()},
\code{\link{plot_pie_panel}()},
\code{\link{plot_subwt_regression}()}
}
\concept{visualization functions}
