% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baggr_compare.R
\name{baggr_compare}
\alias{baggr_compare}
\title{(Run and) compare multiple baggr models}
\usage{
baggr_compare(..., what = "pooling", compare = "groups", transform = NULL)
}
\arguments{
\item{...}{Either some (at least 1) objects of class \code{baggr}
(you should name your objects, see the example below)
or the same arguments you'd pass to \link{baggr}.
In the latter case you must specify \code{what} to compare.}

\item{what}{One of \code{"pooling"} (comparison between no, partial and
full pooling) or \code{"prior"} (comparison between prior and
posterior predictive). If pre-existing baggr models are
passed to \code{...}, this argument is ignored.}

\item{compare}{When plotting, choose between comparison of \code{"groups"}
(default) or (hyper-) \code{"effects"}. The former is not available
when \code{what = "prior"}.}

\item{transform}{a function (e.g. exp(), log()) to apply to
the values of group (and hyper, if hyper=TRUE)
effects before plotting; when working with
effects that are on log scale,
exponent transform is used automatically,
you can plot on log scale by setting
transform = identity}
}
\value{
an object of class \code{baggr_compare}
}
\description{
Compare multiple \link{baggr} models by either
providing multiple already existing models as (named) arguments or
passing parameters necessary to run a \link{baggr} model.
}
\details{
If you pass parameters to the function you must specify
what kind of comparison you want, either "pooling" which
will run fully/partially/un-pooled models and compare them
or "prior" which will generate estimates without the data
and compare them to the model with the full data. For more
details see \link{baggr}, specifically the PPD argument.
}
\examples{
\donttest{
# Most basic comparison between no, partial and full pooling
# (This will run the models)

# run model with just prior and then full data for comparison
# with the same arguments that are passed to baggr
prior_comparison <-
    baggr_compare(schools,
                  model = 'rubin',
                  prior_hypermean = normal(0, 3),
                  prior_hypersd = normal(0,2),
                  prior_hypercor = lkj(2),
                  what = "prior")

# print the aggregated treatment effects
prior_comparison

# plot the comparison of the two distributions
plot(prior_comparison)

# Now compare different types of pooling for the same model
pooling_comparison <-
   baggr_compare(schools,
                 model = 'rubin',
                 prior_hypermean = normal(0, 3),
                 prior_hypersd = normal(0,2),
                 prior_hypercor = lkj(2),
                 what = "pooling")

# plot this comparison
plot(pooling_comparison)

# Compare existing models:
bg1 <- baggr(schools, pooling = "partial")
bg2 <- baggr(schools, pooling = "full")
baggr_compare("Partial pooling model" = bg1, "Full pooling" = bg2,
              arrange = "grid")

#' ...or simply draw prior predictive dist (note ppd=T)
bg1 <- baggr(schools, ppd=T)
bg2 <- baggr(schools, prior_hypermean = normal(0, 5), ppd=T)
baggr_compare("Prior A, p.p.d."=bg1,
              "Prior B p.p.d."=bg2,
              compare = "effects")

# Compare posterior effects as a function of priors (note ppd=F)
bg1 <- baggr(schools, prior_hypersd = uniform(0, 20))
bg2 <- baggr(schools, prior_hypersd = normal(0, 5))
baggr_compare("Uniform prior on SD"=bg1,
              "Normal prior on SD"=bg2,
              compare = "effects")
# You can also compare different subsets of input data
bg1_small <- baggr(schools[1:6,], pooling = "partial")
baggr_compare("8 schools model" = bg1, "First 6 schools" = bg1_small)
}
}
\seealso{
\link{plot.baggr_compare} and \link{print.baggr_compare} for working with results of this function
}
\author{
Witold Wiecek, Brice Green
}
