#' @title dataCovidBeds20200624  
#' 
#' @description 
#' A data set of COVID-19 cases with 99 obs. of  11 variables.
#' 
#' @format A data frame with 32239 rows and 6 columns:
#' \describe{
#'   \item{bed}{int  2 2 3 3 3 3 3 3 4 4 ...}
#'   \item{intensiveBed}{int  0 0 0 0 0 0 0 0 0 0 ...}
#'   \item{intensiveBedVentilation}{int  0 0 0 0 0 0 0 0 0 0 ...}
#'   \item{Day}{Date, format: "2020-03-03" "2020-03-04" "2020-03-05" "2020-03-06" ...}
#'   \item{Infected}{num  5 0 0 0 0 0 0 7 2 5 ...}
#'   \item{Sick}{num  5 5 5 5 5 5 5 12 14 19 ...}
#' }
#' The variable \code{obk$Sick} was generated from the Infected data as follows:
#' \code{slide_dbl(obk$Infected, ~sum(.x), .before = (amntDaysSickness -1)) }
#' \code{amntDaysSickness} was set to 20.
#'
#' 
#' @examples
#' x <- dataCovidBeds20200624
#' # first look
#' str(x)
#' 
#' # plot  
#' x$InfCum <- cumsum(x$Infected)
#' plot(x$Day, x$InfCum, type="l", log="y", ylim=c(1,500))
#' lines(x$Day, x$Infected + 1e-6)
#'  
#'    
###################################################################################
"dataCovidBeds20200624"
