% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic.R
\name{create_topic}
\alias{create_topic}
\alias{delete_topic}
\alias{list_topics}
\title{Manage topics}
\usage{
create_topic(name, ...)

delete_topic(topic, ...)

list_topics(token, ...)
}
\arguments{
\item{name}{A character string containing a (private) name for the topic.}

\item{...}{Additional arguments passed to \code{\link{snsHTTP}}.}

\item{topic}{A character string containing an SNS Topic Amazon Resource Name (ARN).}

\item{token}{A paging paramter used to return additional pages of results. This will be available in the \dQuote{NextToken} attribute of a previous call to \code{list_topics}.}
}
\value{
For \code{create_topic}: If successful, a character string containing an SNS Topic ARN. Otherwise, a data structure of class \dQuote{aws_error} containing any error message(s) from AWS and information about the request attempt.
For \code{delete_topic}: If successful, a logical \code{TRUE}. Otherwise, a data structure of class \dQuote{aws_error} containing any error message(s) from AWS and information about the request attempt.
For \code{list_topics}: If successful, a data frame. Otherwise, a data structure of class \dQuote{aws_error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
Create, delete, and list topics
}
\details{
\code{create_topic} creates a new topic. The \code{name} is a private name for the topic. Use \code{\link{set_topic_attrs}} to set a publicly visible name for the topic. \code{delete_topic} deletes a named topic. \code{list_topics} lists all currently available topics.

\code{list_topics} lists topics. Up to 100 subscriptions are returned by each request. The \code{token} argument can be used to return additional results.
}
\examples{
\dontrun{
  top <- create_topic("new_topic")
  get_topic_attrs(top)
  list_topics()
  delete_topic(top)
}
}
\references{
\href{http://docs.aws.amazon.com/sns/latest/api/API_CreateTopic.html}{CreateTopic}
 \href{http://docs.aws.amazon.com/sns/latest/api/API_DeleteTopic.html}{DeleteTopic}
 \href{http://docs.aws.amazon.com/sns/latest/api/API_ListTopics.html}{ListTopics}
}
\seealso{
\code{link{delete_topic}}
}
\author{
Thomas J. Leeper
}
