% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_launch_template_version}
\alias{ec2_create_launch_template_version}
\title{Create Launch Template Version}
\usage{
ec2_create_launch_template_version(
  LaunchTemplateData,
  DryRun = NULL,
  ClientToken = NULL,
  LaunchTemplateId = NULL,
  LaunchTemplateName = NULL,
  SourceVersion = NULL,
  VersionDescription = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{LaunchTemplateData}{Object. The information for the launch template.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{Character.   Unique, case-sensitive identifier you provide to ensure the idempotency of the request.[optional]}

\item{LaunchTemplateId}{Character. The ID of the launch template.[optional]}

\item{LaunchTemplateName}{Character. The name of the launch template.[optional]}

\item{SourceVersion}{Character. The version number of the launch template version on which to base the new version.[optional]}

\item{VersionDescription}{Character. A description for the version of the launch template.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Create Launch Template Version
}
\section{LaunchTemplateData}{

The information for the launch
template.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{


Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.

Constraint: Maximum 128 ASCII characters.
}

\section{LaunchTemplateId}{

The ID of the launch template. You must specify
either the launch template ID or launch template name in the
request.
}

\section{LaunchTemplateName}{

The name of the launch template. You must
specify either the launch template ID or launch template name in the
request.
}

\section{SourceVersion}{

The version number of the launch template
version on which to base the new version. The new version inherits the
same launch parameters as the source version, except for parameters that
you specify in \code{LaunchTemplateData}. Snapshots applied to the block
device mapping are ignored when creating a new version unless they are
explicitly included.
}

\section{VersionDescription}{

A description for the version
of the launch template.
}

