% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_start_network_insights_analysis}
\alias{ec2_start_network_insights_analysis}
\title{Start Network Insights Analysis}
\usage{
ec2_start_network_insights_analysis(
  NetworkInsightsPathId,
  ClientToken,
  FilterInArn = NULL,
  DryRun = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{NetworkInsightsPathId}{String. The ID of the path.}

\item{ClientToken}{String. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.}

\item{FilterInArn}{List. The Amazon Resource Names (ARN) of the resources that the path must traverse.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{TagSpecification}{List. The tags to apply.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Starts analyzing the specified path. If the path is
reachable, the operation returns the shortest feasible
path.
}
\section{NetworkInsightsPathId}{

The ID of
the path.
}

\section{ClientToken}{

Unique, case-sensitive identifier that you
provide to ensure the idempotency of the request. For more information,
see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.
}

\section{FilterInArn}{

The
Amazon Resource Names (ARN) of the resources that the path must
traverse.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{TagSpecification}{

The tags to
apply.
}

