% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_availability_zone_group}
\alias{ec2_modify_availability_zone_group}
\title{Modify Availability Zone Group}
\usage{
ec2_modify_availability_zone_group(
  GroupName,
  OptInStatus,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{GroupName}{String. The name of the Availability Zone group, Local Zone group, or Wavelength Zone group.}

\item{OptInStatus}{String. Indicates whether you are opted in to the Local Zone group or Wavelength Zone group.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modify Availability Zone Group
}
\section{GroupName}{

The name of the
Availability Zone group, Local Zone group, or Wavelength Zone
group.
}

\section{OptInStatus}{

Indicates whether you are opted in to the
Local Zone group or Wavelength Zone group. The only valid value is
\verb{opted-in}. You must contact \href{https://console.aws.amazon.com/support/home#/case/create\%3FissueType=customer-service\%26serviceCode=general-info\%26getting-started\%26categoryCode=using-aws\%26services}{AWS Support}
to opt out of a Local Zone group, or Wavelength Zone
group.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

